/*
 * vi:ts=4:sw=4:
 *
 * Project : "Linux Explorer"
 * Copyright 1996. All Rights Reserved.
 * 
 * $RCSfile: menu.cpp,v $
 *
 * $Revision: 1.4 $
 * 
 * $Author: ruben $ 
 * 
 * $Locker:  $
 * 
 * $State: Exp $
 * 
 * 
 * COPYRIGHT
 * =========
 * 
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * OVERVIEW
 * ========
 * 
 * $Log: menu.cpp,v $
 * Revision 1.4  1997/06/09 12:59:23  ruben
 * switched rcs commands again I think...
 * compiled with -Wall -Werror, fixed bugs and potential bugs
 * fixed Mister Data bugs
 *
// Revision 1.3  1997/05/27  09:10:46  ruben
// some indentstuff and reworked include strategy
//
// Revision 1.3  1997/05/27  09:10:46  ruben
// some indentstuff and reworked include strategy
//
 * Revision 1.2  1997/04/06 21:19:37  ruben
 * Added "Refresh Devices" and rescan mounted devices routine
 *
 * Revision 1.1  1997/03/28 17:19:54  ruben
 * Initial revision
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif	 // HAVE_CONFIG_H

#ifdef USE_RCS_ID
static const char rcs_id[] = "$Id: menu.cpp,v 1.4 1997/06/09 12:59:23 ruben Exp $";
#endif	 /* USE_RCS_ID */

#include <qmsgbox.h>
#include <qpopmenu.h>
#include <qkeycode.h>
#include <qapp.h>

#include <menu.h>

/*---------------------------------------------------------------------------*/
ExplorerMenu::ExplorerMenu(QWidget * parent,
			 const char *name):QWidget(parent, name)
{
    //>----------- "new" popupmenu

    QPopupMenu *new_item = new QPopupMenu;

	CHECK_PTR(new_item);
	new_item->insertItem ("File", this, SLOT(mi_new_item()));
	new_item->insertItem ("Directory", this, SLOT(dummy()));
	new_item->insertItem ("File List", this, SLOT(dummy()));
	new_item->insertItem ("Window", this, SLOT(dummy()));

    //>----------- "file" popupmenu

	QPopupMenu *file = new QPopupMenu;

	CHECK_PTR(file);
	file->insertItem ("New",new_item,0);
	file->insertSeparator();
	file->insertItem ("Create Link", this, SLOT(mi_create_link()));
	file->insertItem ("Delete", this, SLOT(mi_delete_nodes()));
	file->insertItem ("Properties", this, SLOT(mi_node_properties()));
	file->insertSeparator();
	file->insertItem ("Close", qApp, SLOT(quit()));

    //>----------- "edit" popupmenu

	QPopupMenu *edit = new QPopupMenu;

	CHECK_PTR(edit);
	int undoID = edit->insertItem("Undo", this, SLOT(dummy()));
	int redoID = edit->insertItem("Redo", this, SLOT(dummy()));

    edit->insertSeparator();
    int cutID   =edit->insertItem("Cut", this, SLOT(dummy()));
    int copyID  =edit->insertItem("Copy", this, SLOT(dummy()));
    int pasteID =edit->insertItem("Paste", this, SLOT(dummy()));
	int pastelID=edit->insertItem("Paste Link", this, SLOT(dummy()));
	edit->insertSeparator();

	edit->insertItem("Select All", this, SLOT(mi_select_all()));
	edit->insertItem("Invert Selection", this, SLOT(mi_select_inverse()));

	edit->setItemEnabled(undoID, FALSE);
	edit->setItemEnabled(redoID, FALSE);

	edit->setItemEnabled(cutID, FALSE);
	edit->setItemEnabled(copyID, FALSE);
	edit->setItemEnabled(pasteID, FALSE);
	edit->setItemEnabled(pastelID, FALSE);

    //>----------- "view" popupmenu

	view = new QPopupMenu;

	CHECK_PTR(view);
    view->setCheckable (TRUE);
	toolbar_id   =view->insertItem("Toolbar", this, SLOT(mi_showtoolbar()));
    framebar_id  =view->insertItem("Dir Info",this, SLOT (mi_showframebar()));
	statusbar_id =view->insertItem("File Info", this, SLOT(mi_showstatusbar()));
	pluginview_id=view->insertItem("Plugin Console", this, SLOT(mi_showpluginframe()));

    view->setItemChecked (toolbar_id,TRUE);
    view->setItemChecked (framebar_id,TRUE);
    view->setItemChecked (statusbar_id,TRUE);
    view->setItemChecked (pluginview_id,TRUE);
    
	view->insertSeparator();

	int largeID=view->insertItem("Large Icons", this, SLOT(dummy()));
	int smllID =view->insertItem("Small Icons", this, SLOT(dummy()));
	int listID =view->insertItem("List", this, SLOT(dummy()));
    int dtlID  =view->insertItem("details", this, SLOT(dummy()));

    view->setItemEnabled (largeID,FALSE);
    view->setItemEnabled (smllID,FALSE);
    view->setItemEnabled (listID,FALSE);
    view->setItemEnabled (dtlID,FALSE);

	view->insertSeparator();

	int arrID =view->insertItem("Arrange icons", this, SLOT(dummy()));
	int lineID=view->insertItem("Line up icons", this, SLOT(dummy()));

    view->setItemEnabled (arrID,FALSE);
    view->setItemEnabled (lineID,FALSE);

	view->insertSeparator();

	view->insertItem("Refresh Dir", this, SLOT(mi_rescan_dir()));
	view->insertItem("Refresh Devices", this, SLOT(mi_rescan_mountedfss()));
	view->insertItem("Options", this, SLOT(mi_config()));

    //>----------- "goto" popupmenu

	QPopupMenu *goto_menu = new QPopupMenu;

	CHECK_PTR(goto_menu);
	goto_menu->insertItem("MountPoint", this, SLOT(mi_go_to_mount()));
	goto_menu->insertItem("Home", this, SLOT(mi_go_to_home()));
	goto_menu->insertItem("Directory", this, SLOT(dummy())); // will be a dialog

    //>----------- "tools" popupmenu

	QPopupMenu *tools = new QPopupMenu;

	CHECK_PTR(tools);
	tools->insertItem("Find", this, SLOT(dummy()));
	tools->insertSeparator();
	tools->insertItem("Go To", goto_menu, 0);
	tools->insertSeparator();
	tools->insertItem("User Edit", this, SLOT(dummy()));
	tools->insertItem("Disk Usage", this, SLOT(dummy()));

    //>----------- "help" popupmenu

	QPopupMenu *help = new QPopupMenu;

	CHECK_PTR(help);
	help->insertItem("Help Topics", this, SLOT(mi_help()));
	help->insertItem("About " EXPLORER_MACHNAME " Explorer", this, SLOT(mi_about()));

    //>----------- the menu itself

	menu = new QMenuBar(parent);
	CHECK_PTR(menu);
	menu->insertItem("&File", file);
	menu->insertItem("&Edit", edit);
	menu->insertItem("&View", view);
	menu->insertItem("&Tools", tools);
	menu->insertItem("&Help", help);
	menu->setFrameStyle(QFrame::Panel | QFrame::Raised);
	menu->setGeometry(0, 0, 100, 18);
	menu->setLineWidth(1);

	menu->setFrameStyle(QFrame::Panel | QFrame::Raised);
	menu->adjustSize();
}
/*---------------------------------------------------------------------------*/
void ExplorerMenu::resizeEvent(QResizeEvent * /* e */ )
{
}
/*---------------------------------------------------------------------------*/
QMenuBar *ExplorerMenu::get_menu()
{
	return (menu);
}
/*---------------------------------------------------------------------------*/
void ExplorerMenu::dummy()
{
	QMessageBox temp_dialog;

	temp_dialog.setText("Sorry, this function is not implemented yet\n");
	temp_dialog.show();
}
/*---------------------------------------------------------------------------*/

                    // implementation of menu items

/*---------------------------------------------------------------------------*/
void ExplorerMenu::mi_rescan_mountedfss()
{
 emit rescan_mtab();	
}
/*---------------------------------------------------------------------------*/
void ExplorerMenu::mi_rescan_dir()
{
 emit rescan_dir();	
}
/*---------------------------------------------------------------------------*/
void ExplorerMenu::mi_about()
{
	AboutFrame *temp_dialog = new AboutFrame(0, 0);
	temp_dialog->show();
}
/*---------------------------------------------------------------------------*/
void ExplorerMenu::mi_go_to_mount()
{
	// go to the mount point currently selected in the mount_box 
}
/*---------------------------------------------------------------------------*/
void ExplorerMenu::mi_go_to_home()
{
 char   *home_sweet_home = getenv("HOME");

 if (home_sweet_home == NULL)	// which means you have no roof over your head

 {
    QMessageBox::message ("Error:",
                          "Whoops,Unable to find your HomeDir",
                          "Ok");
 }
 else
    emit go_to(home_sweet_home);
}
/*---------------------------------------------------------------------------*/
void ExplorerMenu::mi_new_item()
{

}
/*---------------------------------------------------------------------------*/
void ExplorerMenu::mi_create_link()
{

}
/*---------------------------------------------------------------------------*/
void ExplorerMenu::mi_delete_nodes()
{

}
/*---------------------------------------------------------------------------*/
void ExplorerMenu::mi_node_properties()
{

}
/*---------------------------------------------------------------------------*/
void ExplorerMenu::mi_config()
{
	ConfigDialog *temp_dialog = new ConfigDialog(0, "dummy");

	temp_dialog->setCaption("" EXPLORER_MACHNAME " Explorer Config");
	temp_dialog->resize(300, 350);
	temp_dialog->show();
}
/*---------------------------------------------------------------------------*/
void ExplorerMenu::mi_help()
{
	HelpFrame *temp_dialog = new HelpFrame(0, 0);

	// temp_dialog->setMinimumSize (300,240);
	temp_dialog->setCaption("" EXPLORER_MACHNAME " Explorer Online Help");
	temp_dialog->show();
}
/*---------------------------------------------------------------------------*/
void ExplorerMenu::mi_select_all ()
{
 emit do_select_all();
}
/*---------------------------------------------------------------------------*/
void ExplorerMenu::mi_select_inverse ()
{
 emit do_select_inverse();
}
/*---------------------------------------------------------------------------*/
void ExplorerMenu::mi_showtoolbar ()
{
 emit show_toolbar ();

 if (view->isItemChecked (toolbar_id)==TRUE)
  view->setItemChecked (toolbar_id,FALSE);
 else
  view->setItemChecked (toolbar_id,TRUE);
}
/*---------------------------------------------------------------------------*/
void ExplorerMenu::mi_showstatusbar ()
{
 emit show_statusbar ();

 if (view->isItemChecked (statusbar_id)==TRUE)
  view->setItemChecked (statusbar_id,FALSE);
 else
  view->setItemChecked (statusbar_id,TRUE);
}
/*---------------------------------------------------------------------------*/
void ExplorerMenu::mi_showframebar ()
{
 emit show_framebar ();

 if (view->isItemChecked (framebar_id)==TRUE)
  view->setItemChecked (framebar_id,FALSE);
 else
  view->setItemChecked (framebar_id,TRUE);
}
/*---------------------------------------------------------------------------*/
void ExplorerMenu::mi_showpluginframe ()
{
 emit show_pluginframe ();

 if (view->isItemChecked (pluginview_id)==TRUE)
  view->setItemChecked (pluginview_id,FALSE);
 else
  view->setItemChecked (pluginview_id,TRUE); 
}
/*---------------------------------------------------------------------------*/
