/*
 * vi:ts=4:sw=4:
 *
 * Project : "Linux Explorer"
 * Copyright 1996. All Rights Reserved.
 * 
 * $RCSfile: plugin_m.h,v $
 *
 * $Revision: 1.2 $
 * 
 * $Author: ruben $ 
 * 
 * $Locker:  $
 * 
 * $State: Exp $
 * 
 * 
 * COPYRIGHT
 * =========
 * 
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * OVERVIEW
 * ========
 *
 *
 */

#ifndef __PLUGIN_M__
#define __PLUGIN_M__

#include <qmlined.h>

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>

#include "data_tree.h"
#include "file_tool.h"

// must be last
#include "vars.h"
 
#define PLUGIN_INIT   0
#define PLUGIN_QUERY  1
#define PLUGIN_UNLOAD 2

#define NONE          0

struct pl_inf
{
	char    pl_name[50];		// identifier for debugging, etc

	char    pl_ver[15];			// plugin version, this is a string

	char    pl_author[100];		// author < email >

	char    pl_ext[15];			// this is the extention the plugin wants to react on

};

struct plugin_entry
{
	// general stuff

	struct pl_inf *plugin_info;	// info struct which hold internal plugin inf

	char   *path_to_plugin;		// should say enough

	// plugin supported function pointers

	// pointer to next struct

	struct plugin_entry *next;
};

class   DynObj
{
	private:

	void   *dynobjHandle;
	char    symnamebuffer[256];

	// disable copy and assignment

	DynObj(const DynObj &);
	DynObj & operator = (const DynObj &);


	public:

	// enum flags {NONE};
	// enum cmds  {NONE};

	DynObj(const char *, int = NONE);	// Open shared object

	~DynObj();			// Close shared object

	void   *getSymbol(const char *);	// resolve symbol
	const char *makeDlSym(const char *); // get full ascii name of symbol as in object file

	const char *getError();

	void   *get_handle(void)
	{
		return dynobjHandle;
	}
};

class   EPluginManager:public QMultiLineEdit
{

	Q_OBJECT

	private:

	int     scrollb;
	char    plugin_path[PATH_MAX];
	char    plugins_avail;

	struct plugin_entry *entry_top;
	struct plugin_entry *entry_current;

	public:
    
	EPluginManager(QWidget *, const char *);
	~EPluginManager();

	void    eprintf(const char *,...);

	void    load_a_plugin(char *);
	void    load_plugins();
	struct pl_inf *query_a_plugin(DynObj *, char *);
	void    unload_plugins();

	void    add_pl_entry(char *, struct pl_inf *);
	struct plugin_entry *get_plugin_list(void);
};

#endif // __PLUGIN_M__
