// $Id: Cxx_TestSubw.cc,v 1.8 1998/09/24 13:21:42 cvs_christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "Cxx.hh"

bool Cxx::TestSubwidgetsForCtor(const Writer &wr,const Widget &w,bool is_member)
{  for (Widget::const_iterator i=w.begin();i!=w.end();++i)
      switch (wr.IsSubwidget(*i))
      {  case WriterType::no_Subwidgets:
         case WriterType::not_Subwidget:
            if (Writer(*i).NeedConstruct(is_member)) return true;
            break;
         case WriterType::IgnoreTree:
            break;
         case WriterType::IgnoreButTestChildren:
            if (TestSubwidgetsForCtor(wr,*i,is_member)) return true;
            break;
         case WriterType::IgnoreButAcceptChildren:
            for (Widget::const_iterator j=(*i).begin();j!=(*i).end();++j)
            {  if (Writer(*j).NeedConstruct(is_member)) return true;
            }
            break;
      }
   return false;
}

void Cxx::TestSubwidgetsAndDo(const Writer &wr,const Widget &w,
					void (Cxx::*memfunc)(const Widget&))
{  for (Widget::const_iterator i=w.begin();i!=w.end();++i)
      switch (wr.IsSubwidget(*i))
      {  case WriterType::no_Subwidgets:
         case WriterType::not_Subwidget:
            (this->*memfunc)(*i);
            break;
         case WriterType::IgnoreTree:
            break;
         case WriterType::IgnoreButTestChildren:
            TestSubwidgetsAndDo(wr,*i,memfunc);
            break;
         case WriterType::IgnoreButAcceptChildren:
            for (Widget::const_iterator j=(*i).begin();j!=(*i).end();++j)
            {  (this->*memfunc)(*j);
            }
            break;
      }
}

void Cxx::TestSubwidgetsAndDo(const Writer &wr,const Widget &w,
		void (Cxx::*memfunc)(const Widget&,const string),const string t)
{  for (Widget::const_iterator i=w.begin();i!=w.end();++i)
      switch (wr.IsSubwidget(*i))
      {  case WriterType::no_Subwidgets:
         case WriterType::not_Subwidget:
            (this->*memfunc)(*i,t);
            break;
         case WriterType::IgnoreTree:
            break;
         case WriterType::IgnoreButTestChildren:
            TestSubwidgetsAndDo(wr,*i,memfunc,t);
            break;
         case WriterType::IgnoreButAcceptChildren:
            for (Widget::const_iterator j=(*i).begin();j!=(*i).end();++j)
            {  (this->*memfunc)(*j,t);
            }
            break;
      }
}

void Cxx::TestSubwidgetsAndDo(const Writer &wr,const Widget &w,
		void (Cxx::*memfunc)(const Widget&,bool,bool*),bool t,bool *u)
{  for (Widget::const_iterator i=w.begin();i!=w.end();++i)
      switch (wr.IsSubwidget(*i))
      {  case WriterType::no_Subwidgets:
         case WriterType::not_Subwidget:
            (this->*memfunc)(*i,t,u);
            break;
         case WriterType::IgnoreTree:
            break;
         case WriterType::IgnoreButTestChildren:
            TestSubwidgetsAndDo(wr,*i,memfunc,t,u);
            break;
         case WriterType::IgnoreButAcceptChildren:
            for (Widget::const_iterator j=(*i).begin();j!=(*i).end();++j)
            {  (this->*memfunc)(*j,t,u);
            }
            break;
      }
}

bool Cxx::TestSubwidgetsForPointer(const Writer &wr,const Widget &w)
{  for (Widget::const_iterator i=w.begin();i!=w.end();++i)
      switch (wr.IsSubwidget(*i))
      {  case WriterType::no_Subwidgets:
         case WriterType::not_Subwidget:
            if ((*i).isPointer()) return true;
            break;
         case WriterType::IgnoreTree:
            break;
         case WriterType::IgnoreButTestChildren:
            if (TestSubwidgetsForPointer(wr,*i)) return true;
            break;
         case WriterType::IgnoreButAcceptChildren:
            for (Widget::const_iterator j=(*i).begin();j!=(*i).end();++j)
            {  if ((*j).isPointer()) return true;
            }
            break;
      }
   return false;
}
