// $Id: Naming.hh,v 1.11 1998/10/08 08:43:52 cvs_christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef NAMING_HH
#define NAMING_HH
#include <string>
#include "File_type.hh"
#include "Widget.hh"

#define GLADEMM_REQUIRED "_GLADEMM_REQUIRED"

class Naming
{               
public:
	// map illegal chars
	string FName(const string tag) const throw()
	{  return tag; }
	// map illegal chars
	string CName(const string tag) const throw();
	// map illegal chars
	string AMName(const string tag) const throw()
	{  return CName(tag); }
	string TypeName(const string tag,bool glade=false) const;
	string InstanceName(const string tag) const;
	string RequireName(const string tag) const;
	string FileName(const string tag,File_type tp,int flags=0) const;
	string FileDefine(const string tag,File_type tp) const;
	// 2do: map illegal chars (e.g. '"','\\','\n')
	string CString(const string s) const throw();
	string Pointer(const Widget &w) const
	{  string ret(InstanceName(w.Name()));
	   if (!w.isPointer()) ret="&"+ret;
	   return ret;
	}
	string Declaration(const Widget &w) const
	{  string ret(InstanceName(w.Name()));
	   if (w.isPointer()) ret="*"+ret;
	   return ret;
	}
};
#endif
