// $Id: Tag.cc,v 1.3 1998/09/24 13:21:44 cvs_christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "Tag.hh"
#include <algo.h>

const Tag *Tag::find(const string tp) const
{  const_iterator i=::find(begin(),end(),tp);
   if (i==end()) return 0;
   return &*i;
}

Tag *Tag::find(const string tp)
{  iterator i=::find(begin(),end(),tp);
   if (i==end()) return 0;
   return &*i;
}

void Tag::debug(bool recursion,int indent) const
{  cout.write("                                                       ",indent);
   cout << "\"" << Type() << "\"";
   if (Value()[0]) cout << "=\"" << Value() << "\"";
   cout << "\n";
   if (recursion)
      for (const_iterator i=begin();i!=end();++i)
         (*i).debug(recursion,indent+2);
}
