// $Id: entry.cc,v 1.13 1998/10/07 14:13:30 cvs_christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "writers.hh"

void Gtk_Entry::Include(File &f,const Widget &w)
{  f.include("gtk--/entry.h");
}

void Gtk_Entry::Declare(File &f,const Widget &w)
{  StandardWriter::Declare(f,w,"Gtk_Entry");
}

void Gtk_Entry::Construct(File &f,const Widget &w,bool is_member)
{  f << StandardWriter::ConstructName(f,w,is_member,"Gtk_Entry") << "()";
}

bool Gtk_Entry::NeedConstruct(const Widget &w,bool is_member)
{  return false;
}

void Gtk_Entry::Customize(File &f,const Widget &w,const string instance)
{  Gtk_Widget::Customize(f,w,instance);
   int position(w.getInt("position",0));
   if (position)
      f << instance << "set_position(" << position << ");\n\t";
   bool text_visible(w.getBool("text_visible","true"));
   if (!text_visible)
      f << instance << "set_visibility(" << (text_visible?"true":"false") << ");\n\t";
   bool editable(w.getBool("editable","true"));
   f << instance << "set_editable(" << (editable?"true":"false") << ");\n\t";
   // max length ... seems to be not in gtkmm
   string text(w.getString("text",""));
   if (text.size())
      f << instance << "set_text(\"" << f.CString(text) << "\");\n\t";
}
