// $Id: standard.hh,v 1.13 1998/09/24 13:19:49 cvs_christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef STANDARDWRITER_HH
#define STANDARDWRITER_HH
//
// Common Writer Functions
//

struct StandardWriter
{  static void AddChildren(File &f,const Widget &w,const string instance);
   static void AddChild(File &f,const Widget &w,const string instance);

   static void Declare(File &f,const Widget &w,const string type)
   {  f << type << " " << f.Declaration(w) << ";";
   }

   // this is not needed until parametrized subwidgets exist
   static bool NeedConstructCompound(const Widget &w,bool is_member)
   {  return false; }
   static void ConstructCompound(File &f,const Widget &w,bool is_member);
   static void DeclareCompound(File &f,const Widget &w);

   static const string ConstructName(File &f,const Widget &w,bool is_member,const string type)
   {  return is_member ? f.InstanceName(w.Name()) : type;
   }
   
   static void ConstructPointer(File &f,const Widget &w);
   static void DestructPointer(File &f,const Widget &w);
};

#endif
