/*
 *	Ohio Trollius
 *	Copyright 1994 The Ohio State University
 *	GDB
 *
 *	$Log:	nrecv.c,v $
 * Revision 6.1  96/11/23  18:45:18  nevin
 * Ohio Release
 * 
 * Revision 6.0  96/02/29  13:32:13  gdburns
 * Ohio Release
 * 
 * Revision 5.2  94/08/22  13:51:15  gdburns
 * Ohio Release
 * 
 * Revision 5.1.1.1  94/08/18  11:11:46  gdburns
 * overhaul for new kernel
 * 
 * Revision 5.1  94/05/18  10:42:47  gdburns
 * Ohio Release
 * 
 * Revision 2.3  94/04/22  12:28:18  gdburns
 * Ohio Release
 * 
 * Revision 2.2  94/02/16  14:23:18  gdburns
 * pre-release to 2.3
 * 
 *	Function:	- receives a buffered network message
 *	Accepts:	- ptr to network message descriptor
 *	Returns:	- 0 or ERROR
 */

#include <bfreq.h>
#include <events.h>
#include <net.h>

int
nrecv(nhead)

struct nmsg		*nhead;

{
	struct bfreq	*req;		/* bufferd request */
	struct nmsg	bfhead;		/* bufferd message */

	if (!(nhead->nh_flags & NOBUF)) {
		req = (struct bfreq *) bfhead.nh_data;
		req->bfq_req = BFQRECV;
		req->bfq_event = nhead->nh_event;
		req->bfq_type = nhead->nh_type;
		bfhead.nh_dl_event = EVBUFFERD;
		bfhead.nh_node = LOCAL;
		bfhead.nh_event = EVBUFFERD;
		bfhead.nh_type = DLCTL;
		bfhead.nh_flags = 0;
		bfhead.nh_length = 0;
		bfhead.nh_msg = 0;

		return(dsfr(&bfhead, nhead));
	} else {
		return(frecv(nhead));
	}
}
