/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	GDB/NJN
 *
 *	$Id: rfatexit.c,v 6.1 96/11/23 19:58:47 nevin Rel $
 *
 *	Function:	- close file descriptors
 *			- don't bother with standard I/O
 */

#include <freq.h>
#include <kio.h>

/*
 * external variables
 */
extern struct fclient	_ufd[];			/* client file descs */
extern struct kio_t	_kio;			/* kernel IO block */

/*
 * external functions
 */
extern int		rfclose();

void
rfatexit()
{
    int			i;
    int			tfd;

    for (i = 0 ; i < FUMAX ; i++) {
	
	tfd = _ufd[i].fu_tfd;
		
	if (tfd > 2) {
/*
 * IO daemon now closes LAM stdio for remote processes (where necessary) but
 * it must still be done here for local processes.  Non-stdio descriptors must
 * be closed regardless.  
 */
	    if (_ufd[i].fu_tflags &&
		    (_kio.ki_rtf & RTF_PFDIO || 
			    (tfd != _kio.ki_stdout && tfd != _kio.ki_stderr))) {

		lam_rfclose(i);
	    }
	}
    }
}
