/*
 *	Ohio Trollius
 *	Copyright 1993 The Ohio State University
 *	GDB
 *
 *	$Log:	rfaux.c,v $
 * Revision 6.1  96/11/23  19:58:49  nevin
 * Ohio Release
 * 
 * Revision 6.0  96/02/29  13:50:06  gdburns
 * Ohio Release
 * 
 * Revision 5.2  94/08/22  13:59:12  gdburns
 * Ohio Release
 * 
 * Revision 5.1  94/05/18  10:58:09  gdburns
 * Ohio Release
 * 
 * Revision 2.3  94/04/22  12:38:24  gdburns
 * Ohio Release
 * 
 * Revision 2.2.1.1  93/05/04  14:46:28  raja
 * Fixed nodeid skipping in _fnparse().
 * 
 * Revision 2.2  92/04/30  14:41:32  trillium
 * Ohio Release
 * 
 * Revision 2.1  91/02/24  20:57:42  gdburns
 * Ohio Release
 *
 *	Function:	- useful auxiliary functions for the file runtime
 *			  library
 */

#include <ctype.h>
#include <errno.h>
#include <events.h>
#include <freq.h>
#include <ksignal.h>
#include <net.h>
#include <typical.h>

/*
 * external variables
 */
extern int		errno;		/* error number */
extern struct fclient	_ufd[FUMAX];	/* client file descriptor table */

/*
 * global functions
 */
int			_fdvalid();	/* check validity of file desc */ 
int			_makefreq();	/* make a simple filed request */
char			*_fnparse();	/* parse nodeid from file name */

/*
 *	makefreq
 *
 *	Function:	- simple request to filed
 *
 *	Accepts:	- node ID of filed
 *			- request code
 *			- generic parameter
 *			- ptr to input buffer
 *			- length of input buffer
 *			- ptr to output buffer
 *			- length of output buffer
 *
 *	Returns:	- reply code from filed
 */

int
_makefreq(node, req, param, ibuf, ilen, obuf, olen)

int4			node;
int			req;
int4			param;
char			*ibuf;
int4			ilen;
char			*obuf;
int4			olen;

{
	struct nmsg	nhead;		/* network message desc. */
	struct freq  	*request;	/* filed request */
	struct freply	*reply;		/* filed reply */
	int		mask;		/* signal mask */


	request = (struct freq *) nhead.nh_data;
	reply = (struct freply *) nhead.nh_data;
/*
 * Set up the filed request.
 */
	request->fq_src_node = (node == LOCAL) ? LOCAL : getnodeid();
	request->fq_src_event = -getpid();
	request->fq_req = (int4) req;
	request->fq_param0 = param;
/*
 * Set up the request message descriptor.
 */
	nhead.nh_node = node;
	nhead.nh_event = EVFILED;
	nhead.nh_type = 0;
	nhead.nh_flags = 0;
	nhead.nh_length = ilen;
	nhead.nh_msg = ibuf;

	if (nsend(&nhead)) {
		return(ERROR);
	}

	mask = ksigblock(sigmask(SIGUDIE) | sigmask(SIGARREST));
/*
 * Set up the reply message descriptor.
 */
	nhead.nh_event = -getpid();
	nhead.nh_length = olen;
	nhead.nh_msg = obuf;

	if (nrecv(&nhead)) {
		return(ERROR);
	}

	(void) ksigsetmask(mask);

	if (reply->fr_errno != 0) {
		errno = reply->fr_errno;
	}

	return(reply->fr_ret);
}

/*
 *	fnparse
 *
 *	Function:	- parse extended file name for server node
 *			  and local file name
 *
 *	Accepts:	- extened file name
 *			- ptr to server node ID (value returned)
 *
 *	Returns:	- ptr to local file name
 */

char *
_fnparse(xname, node)

char			*xname;
int4			*node;

{
	char		*cp;		/* search char ptr */

	for (cp = xname; (*cp != '\0') && isdigit(*cp); ++cp) {
	}

	if ((*cp == ':') && (cp != xname)) {
		*node = atoi4(xname);
		xname = cp + 1;
	}

	else {
		*node = getorigin();
	}

	return(xname);
}

/*
 *	fdvalid
 *
 *	Function:	- check validity of user file descriptor handle
 *
 *	Accepts:	- handle
 *
 *	Returns:	- 0 or ERROR
 */

int
_fdvalid(fd)

{
	if ((fd < 0) || (fd > FUMAX) || (_ufd[fd].fu_tflags == 0)) {
		errno = EBADF;
		return(ERROR);
	} else {
		return(0);
	}
}
