/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	NJN/RBD
 *
 *	$Id: MPISYS.h,v 6.1 96/11/22 14:11:14 nevin Rel $
 *
 *	Function:	- F77 wrappers for MPI library
 */

#ifndef _MPISYS_F77_H
#define _MPISYS_F77_H

#undef	PROFILELIB

#include <lam_config.h>
#include <mpi.h>

/*
 * macros
 */
#define TYPETBLSIZE	64

#define GETHDL(x)	(((x) >= 0) ? lam_F_types[(x)] : 0)
#define BUF(x)		(((x) == lam_F_bottom) ? (char *) 0 : (x))


#if FORTRANNOUNDERSCORE

#define mpi_abort_			mpi_abort
#define mpi_accept_			mpi_accept
#define mpi_address_			mpi_address
#define mpi_allgather_			mpi_allgather
#define mpi_allgatherv_			mpi_allgatherv
#define mpi_allreduce_			mpi_allreduce
#define mpi_alltoall_			mpi_alltoall
#define mpi_alltoallv_			mpi_alltoallv
#define mpi_attr_delete_		mpi_attr_delete
#define mpi_attr_get_			mpi_attr_get
#define mpi_attr_put_			mpi_attr_put
#define mpi_barrier_			mpi_barrier
#define mpi_bcast_			mpi_bcast
#define mpi_bsend_			mpi_bsend
#define mpi_bsend_init_			mpi_bsend_init
#define mpi_buffer_attach_		mpi_buffer_attach
#define mpi_buffer_detach_		mpi_buffer_detach
#define mpi_cancel_			mpi_cancel
#define mpi_cart_coords_		mpi_cart_coords
#define mpi_cart_create_		mpi_cart_create
#define mpi_cart_get_			mpi_cart_get
#define mpi_cart_map_			mpi_cart_map
#define mpi_cart_rank_			mpi_cart_rank
#define mpi_cart_shift_			mpi_cart_shift
#define mpi_cart_sub_			mpi_cart_sub
#define mpi_cartdim_get_		mpi_cartdim_get
#define mpi_comm_compare_		mpi_comm_compare
#define mpi_comm_create_		mpi_comm_create
#define mpi_comm_disconnect_		mpi_comm_disconnect
#define mpi_comm_dup_			mpi_comm_dup
#define mpi_comm_free_			mpi_comm_free
#define mpi_comm_group_			mpi_comm_group
#define mpi_comm_rank_			mpi_comm_rank
#define mpi_comm_remote_group_		mpi_comm_remote_group
#define mpi_comm_remote_size_		mpi_comm_remote_size
#define mpi_comm_size_			mpi_comm_size
#define mpi_comm_split_			mpi_comm_split
#define mpi_comm_test_inter_		mpi_comm_test_inter
#define mpi_connect_			mpi_connect
#define mpi_dims_create_		mpi_dims_create
#define mpi_errhandler_create_		mpi_errhandler_create
#define mpi_errhandler_free_		mpi_errhandler_free
#define mpi_errhandler_get_		mpi_errhandler_get
#define mpi_errhandler_set_		mpi_errhandler_set
#define mpi_error_class_		mpi_error_class
#define mpi_error_string_		mpi_error_string
#define mpi_finalize_			mpi_finalize
#define mpi_gather_			mpi_gather
#define mpi_gatherv_			mpi_gatherv
#define mpi_get_count_			mpi_get_count
#define mpi_get_elements_		mpi_get_elements
#define mpi_get_processor_name_		mpi_get_processor_name
#define mpi_get_version_		mpi_get_version
#define mpi_graph_create_		mpi_graph_create
#define mpi_graph_get_			mpi_graph_get
#define mpi_graph_map_			mpi_graph_map
#define mpi_graph_neighbors_		mpi_graph_neighbors
#define mpi_graph_neighbors_count_	mpi_graph_neighbors_count
#define mpi_graphdims_get_		mpi_graphdims_get
#define mpi_group_compare_		mpi_group_compare
#define mpi_group_difference_		mpi_group_difference
#define mpi_group_excl_			mpi_group_excl
#define mpi_group_free_			mpi_group_free
#define mpi_group_incl_			mpi_group_incl
#define mpi_group_intersection_		mpi_group_intersection
#define mpi_group_range_excl_		mpi_group_range_excl
#define mpi_group_range_incl_		mpi_group_range_incl
#define mpi_group_rank_			mpi_group_rank
#define mpi_group_size_			mpi_group_size
#define mpi_group_translate_ranks_	mpi_group_translate_ranks
#define mpi_group_union_		mpi_group_union
#define mpi_ibsend_			mpi_ibsend
#define mpi_info_create_		mpi_info_create
#define mpi_info_delete_		mpi_info_delete
#define mpi_info_dup_			mpi_info_dup
#define mpi_info_free_			mpi_info_free
#define mpi_info_get_			mpi_info_get
#define mpi_info_get_nkeys_		mpi_info_get_nkeys
#define mpi_info_get_nthkey_		mpi_info_get_nthkey
#define mpi_info_get_valuelen_		mpi_info_get_valuelen
#define mpi_info_set_			mpi_info_set
#define mpi_init_			mpi_init
#define mpi_initialized_		mpi_initialized
#define mpi_intercomm_create_		mpi_intercomm_create
#define mpi_intercomm_merge_		mpi_intercomm_merge
#define mpi_iprobe_			mpi_iprobe
#define mpi_irecv_			mpi_irecv
#define mpi_irsend_			mpi_irsend
#define mpi_isend_			mpi_isend
#define mpi_issend_			mpi_issend
#define mpi_keyval_create_		mpi_keyval_create
#define mpi_keyval_free_		mpi_keyval_free
#define mpi_name_get_			mpi_name_get
#define mpi_name_publish_		mpi_name_publish
#define mpi_name_unpublish_		mpi_name_unpublish
#define mpi_op_create_			mpi_op_create
#define mpi_op_free_			mpi_op_free
#define mpi_pack_			mpi_pack
#define mpi_pack_size_			mpi_pack_size
#define mpi_pcontrol_			mpi_pcontrol
#define mpi_port_close_			mpi_port_close
#define mpi_port_open_			mpi_port_open
#define mpi_probe_			mpi_probe
#define mpi_recv_			mpi_recv
#define mpi_recv_init_			mpi_recv_init
#define mpi_reduce_			mpi_reduce
#define mpi_reduce_scatter_		mpi_reduce_scatter
#define mpi_request_free_		mpi_request_free
#define mpi_rsend_			mpi_rsend
#define mpi_rsend_init_			mpi_rsend_init
#define mpi_scan_			mpi_scan
#define mpi_scatter_			mpi_scatter
#define mpi_scatterv_			mpi_scatterv
#define mpi_send_			mpi_send
#define mpi_send_init_			mpi_send_init
#define mpi_sendrecv_			mpi_sendrecv
#define mpi_sendrecv_replace_		mpi_sendrecv_replace
#define mpi_spawn_			mpi_spawn
#define mpi_spawn_multiple_		mpi_spawn_multiple
#define mpi_ssend_			mpi_ssend
#define mpi_ssend_init_			mpi_ssend_init
#define mpi_start_			mpi_start
#define mpi_startall_			mpi_startall
#define mpi_test_			mpi_test
#define mpi_test_cancelled_		mpi_test_cancelled
#define mpi_testall_			mpi_testall
#define mpi_testany_			mpi_testany
#define mpi_testsome_			mpi_testsome
#define mpi_topo_test_			mpi_topo_test
#define mpi_type_commit_		mpi_type_commit
#define mpi_type_contiguous_		mpi_type_contiguous
#define mpi_type_count_			mpi_type_count
#define mpi_type_extent_		mpi_type_extent
#define mpi_type_free_			mpi_type_free
#define mpi_type_hindexed_		mpi_type_hindexed
#define mpi_type_hvector_		mpi_type_hvector
#define mpi_type_indexed_		mpi_type_indexed
#define mpi_type_lb_			mpi_type_lb
#define mpi_type_size_			mpi_type_size
#define mpi_type_struct_		mpi_type_struct
#define mpi_type_ub_			mpi_type_ub
#define mpi_type_vector_		mpi_type_vector
#define mpi_unpack_			mpi_unpack
#define mpi_wait_			mpi_wait
#define mpi_waitall_			mpi_waitall
#define mpi_waitany_			mpi_waitany
#define mpi_waitsome_			mpi_waitsome
#define mpi_wtick_			mpi_wtick
#define mpi_wtime_			mpi_wtime

#define mpil_comm_id_			mpil_comm_id
#define mpil_comm_gps_			mpil_comm_gps
#define mpil_type_id_			mpil_type_id
#define mpil_signal_			mpil_signal
#define mpil_spawn_			mpil_spawn
#define mpil_comm_parent_		mpil_comm_parent
#define mpil_universe_size_		mpil_universe_size
#define mpil_trace_on_			mpil_trace_on
#define mpil_trace_off_			mpil_trace_off

#define mpi_dup_fn_			mpi_dup_fn
#define mpi_null_copy_fn_		mpi_null_copy_fn
#define mpi_null_delete_fn_		mpi_null_delete_fn

#define mpi_bottom_			mpi_bottom
#define mpi_argv_null_			mpi_argv_null
#define mpi_argvs_null_			mpi_argvs_null
#define mpi_errcodes_dontcare_		mpi_errcodes_dontcare

#elif FORTRANDOUBLEUNDERSCORE

#define mpi_abort_			mpi_abort__
#define mpi_accept_			mpi_accept__
#define mpi_address_			mpi_address__
#define mpi_allgather_			mpi_allgather__
#define mpi_allgatherv_			mpi_allgatherv__
#define mpi_allreduce_			mpi_allreduce__
#define mpi_alltoall_			mpi_alltoall__
#define mpi_alltoallv_			mpi_alltoallv__
#define mpi_attr_delete_		mpi_attr_delete__
#define mpi_attr_get_			mpi_attr_get__
#define mpi_attr_put_			mpi_attr_put__
#define mpi_barrier_			mpi_barrier__
#define mpi_bcast_			mpi_bcast__
#define mpi_bsend_			mpi_bsend__
#define mpi_bsend_init_			mpi_bsend_init__
#define mpi_buffer_attach_		mpi_buffer_attach__
#define mpi_buffer_detach_		mpi_buffer_detach__
#define mpi_cancel_			mpi_cancel__
#define mpi_cart_coords_		mpi_cart_coords__
#define mpi_cart_create_		mpi_cart_create__
#define mpi_cart_get_			mpi_cart_get__
#define mpi_cart_map_			mpi_cart_map__
#define mpi_cart_rank_			mpi_cart_rank__
#define mpi_cart_shift_			mpi_cart_shift__
#define mpi_cart_sub_			mpi_cart_sub__
#define mpi_cartdim_get_		mpi_cartdim_get__
#define mpi_comm_compare_		mpi_comm_compare__
#define mpi_comm_create_		mpi_comm_create__
#define mpi_comm_disconnect_		mpi_comm_disconnect__
#define mpi_comm_dup_			mpi_comm_dup__
#define mpi_comm_free_			mpi_comm_free__
#define mpi_comm_group_			mpi_comm_group__
#define mpi_comm_rank_			mpi_comm_rank__
#define mpi_comm_remote_group_		mpi_comm_remote_group__
#define mpi_comm_remote_size_		mpi_comm_remote_size__
#define mpi_comm_size_			mpi_comm_size__
#define mpi_comm_split_			mpi_comm_split__
#define mpi_comm_test_inter_		mpi_comm_test_inter__
#define mpi_connect_			mpi_connect__
#define mpi_dims_create_		mpi_dims_create__
#define mpi_errhandler_create_		mpi_errhandler_create__
#define mpi_errhandler_free_		mpi_errhandler_free__
#define mpi_errhandler_get_		mpi_errhandler_get__
#define mpi_errhandler_set_		mpi_errhandler_set__
#define mpi_error_class_		mpi_error_class__
#define mpi_error_string_		mpi_error_string__
#define mpi_finalize_			mpi_finalize__
#define mpi_gather_			mpi_gather__
#define mpi_gatherv_			mpi_gatherv__
#define mpi_get_count_			mpi_get_count__
#define mpi_get_elements_		mpi_get_elements__
#define mpi_get_processor_name_		mpi_get_processor_name__
#define mpi_get_version_		mpi_get_version__
#define mpi_graph_create_		mpi_graph_create__
#define mpi_graph_get_			mpi_graph_get__
#define mpi_graph_map_			mpi_graph_map__
#define mpi_graph_neighbors_		mpi_graph_neighbors__
#define mpi_graph_neighbors_count_	mpi_graph_neighbors_count__
#define mpi_graphdims_get_		mpi_graphdims_get__
#define mpi_group_compare_		mpi_group_compare__
#define mpi_group_difference_		mpi_group_difference__
#define mpi_group_excl_			mpi_group_excl__
#define mpi_group_free_			mpi_group_free__
#define mpi_group_incl_			mpi_group_incl__
#define mpi_group_intersection_		mpi_group_intersection__
#define mpi_group_range_excl_		mpi_group_range_excl__
#define mpi_group_range_incl_		mpi_group_range_incl__
#define mpi_group_rank_			mpi_group_rank__
#define mpi_group_size_			mpi_group_size__
#define mpi_group_translate_ranks_	mpi_group_translate_ranks__
#define mpi_group_union_		mpi_group_union__
#define mpi_ibsend_			mpi_ibsend__
#define mpi_info_create_		mpi_info_create__
#define mpi_info_delete_		mpi_info_delete__
#define mpi_info_dup_			mpi_info_dup__
#define mpi_info_free_			mpi_info_free__
#define mpi_info_get_			mpi_info_get__
#define mpi_info_get_nkeys_		mpi_info_get_nkeys__
#define mpi_info_get_nthkey_		mpi_info_get_nthkey__
#define mpi_info_get_valuelen_		mpi_info_get_valuelen__
#define mpi_info_set_			mpi_info_set__
#define mpi_init_			mpi_init__
#define mpi_initialized_		mpi_initialized__
#define mpi_intercomm_create_		mpi_intercomm_create__
#define mpi_intercomm_merge_		mpi_intercomm_merge__
#define mpi_iprobe_			mpi_iprobe__
#define mpi_irecv_			mpi_irecv__
#define mpi_irsend_			mpi_irsend__
#define mpi_isend_			mpi_isend__
#define mpi_issend_			mpi_issend__
#define mpi_keyval_create_		mpi_keyval_create__
#define mpi_keyval_free_		mpi_keyval_free__
#define mpi_name_get_			mpi_name_get__
#define mpi_name_publish_		mpi_name_publish__
#define mpi_name_unpublish_		mpi_name_unpublish__
#define mpi_op_create_			mpi_op_create__
#define mpi_op_free_			mpi_op_free__
#define mpi_pack_			mpi_pack__
#define mpi_pack_size_			mpi_pack_size__
#define mpi_pcontrol_			mpi_pcontrol__
#define mpi_port_close_			mpi_port_close__
#define mpi_port_open_			mpi_port_open__
#define mpi_probe_			mpi_probe__
#define mpi_recv_			mpi_recv__
#define mpi_recv_init_			mpi_recv_init__
#define mpi_reduce_			mpi_reduce__
#define mpi_reduce_scatter_		mpi_reduce_scatter__
#define mpi_request_free_		mpi_request_free__
#define mpi_rsend_			mpi_rsend__
#define mpi_rsend_init_			mpi_rsend_init__
#define mpi_scan_			mpi_scan__
#define mpi_scatter_			mpi_scatter__
#define mpi_scatterv_			mpi_scatterv__
#define mpi_send_			mpi_send__
#define mpi_send_init_			mpi_send_init__
#define mpi_sendrecv_			mpi_sendrecv__
#define mpi_sendrecv_replace_		mpi_sendrecv_replace__
#define mpi_spawn_			mpi_spawn__
#define mpi_spawn_multiple_		mpi_spawn_multiple__
#define mpi_ssend_			mpi_ssend__
#define mpi_ssend_init_			mpi_ssend_init__
#define mpi_start_			mpi_start__
#define mpi_startall_			mpi_startall__
#define mpi_test_			mpi_test__
#define mpi_test_cancelled_		mpi_test_cancelled__
#define mpi_testall_			mpi_testall__
#define mpi_testany_			mpi_testany__
#define mpi_testsome_			mpi_testsome__
#define mpi_topo_test_			mpi_topo_test__
#define mpi_type_commit_		mpi_type_commit__
#define mpi_type_contiguous_		mpi_type_contiguous__
#define mpi_type_count_			mpi_type_count__
#define mpi_type_extent_		mpi_type_extent__
#define mpi_type_free_			mpi_type_free__
#define mpi_type_hindexed_		mpi_type_hindexed__
#define mpi_type_hvector_		mpi_type_hvector__
#define mpi_type_indexed_		mpi_type_indexed__
#define mpi_type_lb_			mpi_type_lb__
#define mpi_type_size_			mpi_type_size__
#define mpi_type_struct_		mpi_type_struct__
#define mpi_type_ub_			mpi_type_ub__
#define mpi_type_vector_		mpi_type_vector__
#define mpi_unpack_			mpi_unpack__
#define mpi_wait_			mpi_wait__
#define mpi_waitall_			mpi_waitall__
#define mpi_waitany_			mpi_waitany__
#define mpi_waitsome_			mpi_waitsome__
#define mpi_wtick_			mpi_wtick__
#define mpi_wtime_			mpi_wtime__

#define mpil_comm_id_			mpil_comm_id__
#define mpil_comm_gps_			mpil_comm_gps__
#define mpil_type_id_			mpil_type_id__
#define mpil_signal_			mpil_signal__
#define mpil_spawn_			mpil_spawn__
#define mpil_comm_parent_		mpil_comm_parent__
#define mpil_universe_size_		mpil_universe_size__
#define mpil_trace_on_			mpil_trace_on__
#define mpil_trace_off_			mpil_trace_off__

#define mpi_dup_fn_			mpi_dup_fn__
#define mpi_null_copy_fn_		mpi_null_copy_fn__
#define mpi_null_delete_fn_		mpi_null_delete_fn__

#define mpi_bottom_			mpi_bottom__
#define mpi_argv_null_			mpi_argv_null__
#define mpi_argvs_null_			mpi_argvs_null__
#define mpi_errcodes_dontcare_		mpi_errcodes_dontcare__

#endif

/*
 * external variables
 */
extern int		lam_F_comm_parent;
extern int		lam_F_maxtype;
extern int		lam_F_maxpredef;
extern int		lam_F_ntypes;
extern int		lam_F_typesize;
extern void		**lam_F_types;
extern char		*lam_F_bottom;
extern void		*lam_F_argvnull;
extern void		*lam_F_argvsnull;
extern void		*lam_F_errdontcare;

/*
 * prototypes of LAM MPI library F77 internal functions
 */
#ifndef __ARGS
#if __STDC__ || defined(c_plusplus) || defined(__cplusplus)
#define __ARGS(a)	a
#else
#define __ARGS(a)	()
#endif
#endif

#ifdef __cplusplus
extern "C" {
#endif

extern char 		*lam_F2C_string __ARGS((char *, int));
extern int 		lam_F2C_argv __ARGS((char *, int, char ***));
extern int		lam_F2C_comm __ARGS((int, MPI_Comm *));
extern int		lam_F2C_type __ARGS((int, MPI_Datatype *));
extern void		lam_F2C_stat __ARGS((int *, MPI_Status *));
extern void		lam_C2F_stat __ARGS((MPI_Status *, int *));
extern void		lam_C2F_string __ARGS((char *, char *, int));
extern int		lam_F_typealloc __ARGS((void));
extern int		lam_F_typefind __ARGS((void *));
extern void		lam_F_maketype __ARGS((int *, int *, void *));
extern void		lam_F_typefree __ARGS((int));
extern void		mpi_null_copy_fn_ __ARGS((void));
extern void		mpi_null_delete_fn_ __ARGS((void));

#ifdef __cplusplus
}
#endif

#endif	/* _MPISYS_F77_H */
