/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	GDB
 *
 *	$Id: flatreq.h,v 6.1 96/11/23 21:54:55 nevin Rel $
 *
 *	Function:	- constants and structures associated
 *			  with the flat server
 */

#ifndef _FLATREQ_H
#define _FLATREQ_H

#include <net.h>
#include <portable.h>

/*
 * constants
 */
#define FLPATHLEN	48			/* load file path length */
#define FLMAX		256
#define	EMPTY		((char *) 0)

/*
 * request codes
 */
#define FLQLOAD		1
#define FLQGET		2
#define FLQFORGET	3
#define FLQDONE		4
#define FLQCLEAN	5

/*
 * request template
 */
struct flreq {
	int4		flq_src_node;
	int4		flq_src_event;
	int4		flq_req;
	int4		flq_parm1;
#define flq_tag		flq_parm1
#define flq_pid		flq_parm1
	int4		flq_parm2;
#define flq_malength	flq_parm2
#define flq_dseg	flq_parm2
	int4		flq_parm3;
#define flq_ldlength	flq_parm3
};

/*
 * reply template
 */
struct flreply {
	int4		flr_reply;
};

/*
 * flat table entry
 */
struct flregion {
	int4		fl_tag;			/* identifying tag */
	int4		fl_status;		/* status flag */
	int4		fl_src_event;		/* sender's -pid */
	int4		fl_src_node;		/* sender's nodeid */
	int4		fl_byteswritten;	/* how many so far */
	char		*fl_addr;		/* flatted file name */
};

/*
 * prototypes
 */
#ifndef __ARGS
#if __STDC__ || defined(c_plusplus) || defined(__cplusplus)
#define __ARGS(a)	a
#else
#define __ARGS(a)	()
#endif
#endif

#ifdef __cplusplus
extern "C" {
#endif

extern int		rflat __ARGS((int4, char *, int4, int4, int4));
extern int		rflclean __ARGS((int4, int4));
extern char		*rget __ARGS((int4, int4));

#ifdef __cplusplus
}
#endif

#endif /* _FLATREQ_H */
