/*
 *      Ohio Trollius
 *	Copyright 1995 The Ohio State University
 *      GDB/RBD
 *
 *      $Log:	ktrace.h,v $
 * Revision 6.1  96/11/23  21:55:04  nevin
 * Ohio Release
 * 
 * Revision 6.0  96/02/29  13:53:28  gdburns
 * Ohio Release
 * 
 * Revision 5.2.1.1  96/02/18  01:26:58  gdburns
 * major overhaul
 * 
 * Revision 5.2  94/08/22  14:00:37  gdburns
 * Ohio Release
 * 
 * Revision 5.1  94/05/18  12:44:28  gdburns
 * Ohio Release
 * 
 * Revision 2.3  94/04/22  12:48:55  gdburns
 * Ohio Release
 * 
 *	Function:	- constants and templates associated with the
 *			  runtime trace system
 */

#ifndef _KTRACE
#define _KTRACE

#include <portable.h>

/*
 * trace header
 */
struct trhead {
	char		*trh_buf;	/* trace buffer ptr */
	int4		trh_length;	/* trace buffer length */
};

/*
 * constants
 */
#define TRHMAX		4		/* TRHMAX * MAXNMSGLEN = len limit */
#define TRHQUAN		2		/* TRHQUAN * MAXNMSGLEN = alloc hunk */

/*
 * prototypes
 */
#ifndef __ARGS
#if __STDC__ || defined(c_plusplus) || defined(__cplusplus)
#define __ARGS(a)	a
#else
#define __ARGS(a)	()
#endif
#endif

#ifdef __cplusplus
extern "C" {
#endif

extern char		*lam_trpoint __ARGS((int4 size));
extern void		lam_trexit __ARGS((void));
extern void		lam_trinit __ARGS((void));
extern void		lam_trunload __ARGS((void));

#ifdef __cplusplus
}
#endif

#endif	/* _KTRACE */
