/*
 *	Ohio Trollius
 *	Copyright 1997 The Ohio State University
 *	NJN
 *
 *	$Id: shm.sgi.h,v 6.1.1.2 97/03/24 12:03:56 nevin Exp $
 *
 *	Function:	- shared memory / TCP client-to-client interface header
 *			- SGI shared arena spinlocks
 */

#ifndef _SHM_SGI_H
#define _SHM_SGI_H

#include <errno.h>
#include <ulocks.h>

#include <all_hash.h>
#include <all_list.h>
#include <mpisys.h>
#include <portable.h>
#include <t_types.h>

/*
 * constants
 */
#define C2CINITSIZE	(sizeof(char *) + 4 * sizeof(ulock_t))
						/* initialization data size */
#define INITHASH	((int4) 32)		/* initial hash table size */
#define LAMSHMDELAY	10			/* poll loop delay (usecs) */
#define TCPSHORTMSGLEN 	16384			/* max. length tcp short msg */
#define SHMMAXP		32			/* max. num. shm processes */
#define SHMBLKSIZE 	32768			/* size of shm block */
#define SHMLOCKSIZE	1024			/* size put aside for locks */
#define SHMBUFSIZE 	(SHMBLKSIZE / 2)	/* size of shm buffer */
#define SHMSHORTMSGLEN	(SHMBUFSIZE - sizeof(struct c2c_envl))
						/* max. length shm short msg */
/*
 * Size of shared arena. This is shared by all the processes and there
 * are potentially p(p-1)/2 process pairs for p processes.
 */
#define ARENASIZE	((SHMBLKSIZE + SHMLOCKSIZE) * SHMMAXP * (SHMMAXP-1) / 2)

/*
 * data structures
 *
 * client-to-client specific process data
 */
struct c2c_proc {
	struct c2c_envl	cp_env;			/* incoming envelope */
	int		cp_write;		/* ok to try to write flag */
	int		cp_read;		/* ok to try to read flag */
	int		cp_sock;		/* socket descriptor */
	char		*cp_envbuf;		/* envelope buffer pointer */
	int		cp_nenvin;		/* # env. bytes left to read */
	char		*cp_msgbuf;		/* message buffer pointer */
	int		cp_nmsgin;		/* # msg. bytes left to read */
	int		cp_extra;		/* # bytes to go into sink */
	int		cp_locked;		/* reader has a lock? */
	usptr_t		*cp_arena;		/* shared arena */
	ulock_t		cp_irdlock;		/* input read lock */
	ulock_t		cp_iwtlock;		/* input write lock */
	ulock_t		cp_ordlock;		/* output read lock */
	ulock_t		cp_owtlock;		/* output write lock */
	char		*cp_shmbuf;		/* shared memory buffer */
	char		*cp_shmout;		/* outgoing shm buffer */
	char		*cp_shmin;		/* incoming shm buffer */
	MPI_Request	cp_wreq;		/* req. writing to process */
	MPI_Request	cp_rreq;		/* reading req. */
	MPI_Request	cp_mreq;		/* req. to test matching from */
	int		(*cp_readfn)();		/* read function */
	struct cbuf_msg *cp_bmsg;		/* buffering? */
	int		cp_nbfde;		/* # buffered envelopes */
};

/*
 * locking macros
 */
extern int		_lock_poll;		/* # attempts before yield */

#define _shm_readlock(p)	(uswsetlock((p)->cp_irdlock, _lock_poll) == -1)
#define _shm_readtrylock(p)	_sgi_trylock((p)->cp_irdlock)
#define _shm_readunlock(p)	(usunsetlock((p)->cp_iwtlock) == -1)

#define _shm_writelock(p)	(uswsetlock((p)->cp_owtlock, _lock_poll) == -1)
#define _shm_writetrylock(p)	_sgi_trylock((p)->cp_owtlock)
#define _shm_writeunlock(p)	(usunsetlock((p)->cp_ordlock) == -1)

/*
 * prototypes of LAM MPI library client-to-client internal functions
 */
#ifndef __ARGS
#if __STDC__ || defined(c_plusplus) || defined(__cplusplus)
#define __ARGS(a)	a
#else
#define __ARGS(a)	()
#endif
#endif

#ifdef __cplusplus
extern "C" {
#endif

extern int	_sgi_trylock  __ARGS((ulock_t));

#ifdef __cplusplus
}
#endif

#endif	/* _SHM_SGI_H */
