/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	RBD
 *
 *	$Id: cartget.c,v 6.1 96/11/23 22:51:12 nevin Rel $
 *
 *	Function:	- get info on cartesian topology
 *	Accepts:	- communicator
 *			- size of dimensions array
 *			- dimensions array
 *			- periodicity array
 *			- coordinates array
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>

int
MPI_Cart_get(comm, maxndims, dims, periods, coords)

MPI_Comm		comm;
int			maxndims;
int			*dims;
int			*periods;
int			*coords;

{
	int		i;
	int		*d;
	int		*c;

	lam_initerr();
	lam_setfunc(BLKMPICARTGET);
/*
 * Check the arguments.
 */
	if (comm == MPI_COMM_NULL) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPICARTGET, lam_mkerr(MPI_ERR_COMM, 0)));
	}

	if (LAM_IS_INTER(comm)) {
		return(lam_errfunc(comm,
			BLKMPICARTGET, lam_mkerr(MPI_ERR_COMM, 0)));
	}

	if (!LAM_IS_CART(comm)) {
		return(lam_errfunc(comm, BLKMPICARTGET,
				lam_mkerr(MPI_ERR_TOPOLOGY, 0)));
	}

	if ((maxndims < 0) || ((maxndims > 0) &&
			((dims == 0) || (periods == 0) || (coords == 0)))) {
		return(lam_errfunc(comm,
			BLKMPICARTGET, lam_mkerr(MPI_ERR_ARG, 0)));
	}
/*
 * Fill the dimension, period, and coordinate arrays.
 */
	d = comm->c_topo_dims;
	c = comm->c_topo_coords;
	for (i = 0; (i < comm->c_topo_ndims) && (i < maxndims); ++i) {
		if (*d > 0) {
			*dims++ = *d++;
			*periods++ = 0;
		} else {
			*dims++ = -(*d++);
			*periods++ = 1;
		}

		*coords++ = *c++;
	}

	lam_resetfunc(BLKMPICARTGET);
	return(MPI_SUCCESS);
}
