/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	RBD
 *
 *	$Id: errfree.c,v 6.1 96/11/23 22:51:43 nevin Rel $
 *
 *	Function:	- free error handler
 *	Accepts:	- ptr error handler
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <stdlib.h>

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>

int
MPI_Errhandler_free(errhdl)

MPI_Errhandler		*errhdl;

{
	lam_initerr();
	lam_setfunc(BLKMPIERRFREE);
/*
 * Check the arguments.
 */
	if (errhdl == 0 || *errhdl == MPI_ERRHANDLER_NULL) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPIERRFREE, lam_mkerr(MPI_ERR_ARG, 0)));
	}
/*
 * Only internal library calls can free predefined handlers.
 */
	if (lam_getfunc() == BLKMPIERRFREE && (*errhdl == MPI_ERRORS_ARE_FATAL
			|| *errhdl == MPI_ERRORS_RETURN)) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPIERRFREE, lam_mkerr(MPI_ERR_ARG, 0)));
	}
/*
 * Free the handler.
 */
	if (--((*errhdl)->eh_refcount) == 0) {
		free((char *) *errhdl);
	}

	*errhdl = MPI_ERRHANDLER_NULL;

	lam_resetfunc(BLKMPIERRFREE);
	return(MPI_SUCCESS);
}
