/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio	State University
 *	RBD/NJN
 *
 *	$Id: init_f.c,v 6.1 96/11/22 13:44:37 nevin Rel $
 *
 *	Function:	- MPI_Init F77 wrapper
 */

#include <lam_config.h>

#include <errno.h>
#include <stdlib.h>
#include <string.h>

#include <mpi.h>
#include <MPISYS.h>
#include <mpisys.h>

/*
 * external variables
 */
#if SIZEOF_LONG_DOUBLE == 16
extern long double	mpi_bottom_[];
extern long double	mpi_argv_null_[];
extern long double	mpi_argvs_null_[];
extern long double	mpi_errcodes_dontcare_[];
#else
extern double		mpi_bottom_[];
extern double		mpi_argv_null_[];
extern double		mpi_argvs_null_[];
extern double		mpi_errcodes_dontcare_[];
#endif

void
mpi_init_(ierror)

int			*ierror;

{
	int		argc;
	char		*argv[1];
	char		**pargv;
/*
 * Do an MPI_Init().
 */
	argc = 0;
	argv[0]	= 0;
	pargv =	argv;

	lam_f77init = 1;
	*ierror	= MPI_Init(&argc, &pargv);
	if (*ierror != MPI_SUCCESS) return;
/*
 * Initialize the type lookup table.
 */
	lam_F_typesize = TYPETBLSIZE;
	lam_F_types = (void **)
			malloc((unsigned) lam_F_typesize * sizeof(void *));
	if (lam_F_types	== 0) {
		*ierror	= lam_mkerr(MPI_ERR_OTHER, errno);;
		return;
	}

	memset((char *)	lam_F_types, 0,	lam_F_typesize * sizeof(void *));
/*
 * These must be done in an order that matches the indices given to the
 * F77 constants in mpif.h.
 */
	lam_F_types[lam_F_ntypes++] = MPI_COMM_WORLD;
	lam_F_types[lam_F_ntypes++] = MPI_COMM_SELF;
	lam_F_types[lam_F_ntypes++] = MPI_COMM_PARENT;

	lam_F_types[lam_F_ntypes++] = MPI_GROUP_EMPTY;

	lam_F_types[lam_F_ntypes++] = MPI_ERRORS_ARE_FATAL;
	lam_F_types[lam_F_ntypes++] = MPI_ERRORS_RETURN;

	lam_F_types[lam_F_ntypes++] = MPI_BYTE;
	lam_F_types[lam_F_ntypes++] = MPI_PACKED;
	lam_F_types[lam_F_ntypes++] = MPI_UB;
	lam_F_types[lam_F_ntypes++] = MPI_LB;
	lam_F_types[lam_F_ntypes++] = MPI_F_CHARACTER;
	lam_F_types[lam_F_ntypes++] = MPI_F_LOGICAL;
	lam_F_types[lam_F_ntypes++] = MPI_F_INTEGER;
	lam_F_types[lam_F_ntypes++] = MPI_F_REAL;
	lam_F_types[lam_F_ntypes++] = MPI_F_DOUBLE_PRECISION;
	lam_F_types[lam_F_ntypes++] = MPI_F_COMPLEX;
	lam_F_types[lam_F_ntypes++] = MPI_F_DOUBLE_COMPLEX;
	lam_F_types[lam_F_ntypes++] = MPI_F_2REAL;
	lam_F_types[lam_F_ntypes++] = MPI_F_2DOUBLE_PRECISION;
	lam_F_types[lam_F_ntypes++] = MPI_F_2INTEGER;
	
	lam_F_types[lam_F_ntypes++] = MPI_MAX;
	lam_F_types[lam_F_ntypes++] = MPI_MIN;
	lam_F_types[lam_F_ntypes++] = MPI_SUM;
	lam_F_types[lam_F_ntypes++] = MPI_PROD;
	lam_F_types[lam_F_ntypes++] = MPI_LAND;
	lam_F_types[lam_F_ntypes++] = MPI_BAND;
	lam_F_types[lam_F_ntypes++] = MPI_LOR;
	lam_F_types[lam_F_ntypes++] = MPI_BOR;
	lam_F_types[lam_F_ntypes++] = MPI_LXOR;
	lam_F_types[lam_F_ntypes++] = MPI_BXOR;
	lam_F_types[lam_F_ntypes++] = MPI_MAXLOC;
	lam_F_types[lam_F_ntypes++] = MPI_MINLOC;
	
	lam_F_maxpredef	= lam_F_maxtype	= lam_F_ntypes - 1;

	lam_F_bottom = (char *)	&mpi_bottom_[0];
	lam_F_argvnull = &mpi_argv_null_[0];
	lam_F_argvsnull = &mpi_argvs_null_[0];
	lam_F_errdontcare = &mpi_errcodes_dontcare_[0];
}
