/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio	State University
 *	RBD/NJN
 *
 *	$Id: mpil_spawn_f.c,v 6.1 96/11/22 13:44:37 nevin Rel $
 *
 *	Function:	- MPIL_Spawn, MPIL_Comm_parent,	MPIL_Universe_size
 *			  F77 wrappers
 */

#include <lam_config.h>

#include <mpi.h>
#include <MPISYS.h>
#include <mpisys.h>

/*
 * external variables
 */
extern int		lam_F_comm_parent;


void
mpil_spawn_(c, a, r, ic, ierr)

int	*c, *r,	*ic, *ierr;
char	*a;


{
	MPI_Comm comm;

	*ierr =	MPIL_Spawn(GETHDL(*c), a, *r, &comm);
	lam_F_maketype(ic, ierr, (void *) comm);
}


void
mpil_comm_parent_(c, ierr)

int	*c, *ierr;

{
	*c = lam_F_comm_parent;
	*ierr =	MPI_SUCCESS;
}


void 
mpil_universe_size_(s, ierr)

int	*s, *ierr;

{
	*ierr =	MPIL_Universe_size(s);
}
