/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio	State University
 *	NJN
 *
 *	$Id: nameunpub_f.c,v 6.1 96/11/22 13:44:37 nevin Rel $
 *
 *	Function:	- MPI_Name_unpublish F77 wrapper
 */

#include <lam_config.h>

#include <errno.h>
#include <stdlib.h>

#include <blktype.h>
#include <mpi.h>
#include <MPISYS.h>
#include <mpisys.h>

void
mpi_name_unpublish_(p, s, ierr, np, ns)

char			*p, *s;
int			*ierr;
int			np, ns;

{
	char		*port;
	char		*service;

	port = lam_F2C_string(p, np);
	service	= lam_F2C_string(s, ns);

	if (port == 0 || service == 0) {
		lam_setfunc(BLKMPINAMEUNPUB);
		*ierr =	lam_errfunc(MPI_COMM_WORLD, BLKMPINAMEUNPUB,
					lam_mkerr(MPI_ERR_OTHER, errno));
		return;
	}

	*ierr =	MPI_Name_unpublish(port, service);
	
	free(port);
	free(service);
}
