/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	RBD
 *
 *	$Id: lamdeferr.c,v 6.1 96/11/23 22:52:58 nevin Rel $
 *
 *	Function:	- default MPI error handlers
 */

#include <stdio.h>
#include <unistd.h>

#include <mpi.h>
#include <mpisys.h>
#include <tstdio.h>

/*
 * global functions
 */
void			lam_errfatal();
void			lam_errreturn();

/*
 * static variables
 */
static char		mpierrmsg[MPI_MAX_ERROR_STRING];

/*
 *	lam_errfatal
 *
 *	Function:	- default MPI error function
 *			- print error message and abort
 *	Accepts:	- communicator
 *			- error code
 */
void
lam_errfatal(errcomm, error)

MPI_Comm		*errcomm;
int			*error;

{
	int		rank;
	int		cid;
	int		len;
	MPI_Comm	comm;

	MPI_Error_string(*error, mpierrmsg, &len);

	comm = (errcomm) ? *errcomm : MPI_COMM_WORLD;
	if (comm != MPI_COMM_NULL) {
		MPI_Comm_rank(comm, &rank);
		MPIL_Comm_id(comm, &cid);
		if (_kio.ki_rtf & RTF_IO) {
			printf("%s (rank %d, comm %d)\n", mpierrmsg, rank, cid);
			fflush(stdout);
		} else {
			tprintf("%s (rank %d, comm %d)\n",
					mpierrmsg, rank, cid);
		}
		MPI_Abort(comm, *error);
	} else {
		if (_kio.ki_rtf & RTF_IO) {
			printf("%s (node %d, pid %d)\n",
				mpierrmsg, getnodeid(), (int) getpid());
			fflush(stdout);
		} else {
			tprintf("%s (node %d, pid %d)\n",
				mpierrmsg, getnodeid(), (int) getpid());
		}
		kexit(*error);
	}
}

/*
 *	lam_errreturn
 *
 *	Function:	- predefined error function
 *			- stub that does nothing
 *	Accepts:	- communicator
 *			- error code
 */
void
lam_errreturn(comm, error)

MPI_Comm		*comm;
int			*error;

{
}
