/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	RBD
 *
 *	$Id: opfree.c,v 6.1 96/11/23 22:53:37 nevin Rel $
 *
 *	Function:	- free a reduction operator
 *	Accepts:	- operator (inout)
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <stdlib.h>

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>

int
MPI_Op_free(op)

MPI_Op			*op;

{
	lam_initerr();
	lam_setfunc(BLKMPIOPFREE);

	if (op == 0 || (*op == MPI_OP_NULL)
			|| ((*op)->op_flags & LAM_PREDEF)) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPIOPFREE, lam_mkerr(MPI_ERR_OP, 0)));
	}

	free((char *) *op);
	*op = MPI_OP_NULL;

	lam_resetfunc(BLKMPIOPFREE);
	return(MPI_SUCCESS);
}
