/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	RBD
 *
 *	$Id: ssendinit.c,v 6.1 96/11/23 22:54:18 nevin Rel $
 *
 *	Function:	- create a synchronous send request
 *	Accepts:	- buffer
 *			- count
 *			- datatype
 *			- destination
 *			- tag
 *			- communicator
 *			- request (returned)
 *	Returns: 	- MPI_SUCCESS or error code
 */

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>
#include <rpisys.h>

/*
 * external functions
 */
extern int		lam_errfunc();
extern void		lam_initerr();
extern void		lam_resetfunc();
extern void		lam_setfunc();
extern int		_mpi_req_build();


int
MPI_Ssend_init(buf, count, dtype, dest, tag, comm, req)

void			*buf;
int			count;
MPI_Datatype		dtype;
int			dest;
int			tag;
MPI_Comm		comm;
MPI_Request		*req;

{
	int		err;			/* error code */

	lam_initerr();
	lam_setfunc(BLKMPISSINIT);

	*req = MPI_REQUEST_NULL;
	err = _mpi_req_build(buf, count, dtype, dest, tag, comm,
				LAM_RQISSEND, req);

	if (err != MPI_SUCCESS) {
		return(lam_errfunc(comm, BLKMPISSINIT, err));
	}

	(*req)->rq_marks |= LAM_RQFPERSIST;

	lam_resetfunc(BLKMPISSINIT);
	return(MPI_SUCCESS);
}
