/*
 *	Ohio Trollius
 *	Copyright 1997 The Ohio State University
 *	NJN/RBD
 *
 *	$Id: tcontig.c,v 6.1.1.1 97/02/24 14:34:36 nevin Exp $
 *
 *	Function:	- create contiguous derived datatype
 *	Accepts:	- # elements
 *			- element datatype
 *			- ptr new datatype
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <stdlib.h>

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>
#include <terror.h>

int
MPI_Type_contiguous(count, oldtype, newtype)

int			count;
MPI_Datatype		oldtype;
MPI_Datatype		*newtype;

{
	MPI_Datatype	ntype;			/* new datatype */

	lam_initerr();
	lam_setfunc(BLKMPITCONTIG);
/*
 * Check the arguments.
 */
	if (oldtype == MPI_DATATYPE_NULL) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPITCONTIG, lam_mkerr(MPI_ERR_TYPE, 0)));
	}

	if (count < 0) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPITCONTIG, lam_mkerr(MPI_ERR_COUNT, 0)));
	}

	if (newtype == 0) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPITCONTIG, lam_mkerr(MPI_ERR_ARG, 0)));
	}
/*
 * Create the new datatype.
 */
	ntype = (MPI_Datatype) malloc(sizeof(struct _dtype));
	if (ntype == 0) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPITCONTIG, lam_mkerr(MPI_ERR_OTHER, errno)));
	}

	++oldtype->dt_refcount;

	*newtype = ntype;
	ntype->dt_format = LAM_DTCONTIG;
	ntype->dt_commit = 0;
	ntype->dt_refcount = 1;
	ntype->dt_label = -1;
	ntype->dt_align = (count > 0) ? oldtype->dt_align : 1;
	ntype->dt_count = count;
	ntype->dt_length = 0;
	ntype->dt_stride = 0;
	ntype->dt_dtype = oldtype;
	ntype->dt_lengths = 0;
	ntype->dt_disps = 0;
	ntype->dt_dtypes = 0;
	ntype->dt_size = -1;

	lam_dtblock(ntype, oldtype, count, 0);
	lam_dtalign(ntype);

	lam_resetfunc(BLKMPITCONTIG);
	return(MPI_SUCCESS);
}
