/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	RBD/GDB
 *
 *	$Id: testany.c,v 6.1 96/11/23 22:54:30 nevin Rel $
 *
 *	Function:	- check if one request completed
 *	Accepts:	- # of requests
 *			- array of requests
 *			- index (returned)
 *			- flag (returned)
 *			- status (returned)
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>
#include <mpitrace.h>
#include <rpisys.h>

/*
 * external functions
 */
extern void		lam_emptystat();
extern void		lam_initerr();
extern void		lam_resetfunc();
extern void		lam_setfunc();
extern void		lam_tr_wrapend();
extern int		lam_tr_wrapstart();
extern int		lam_mkerr();


int

MPI_Testany(count, reqs, index, flag, stat)

int			count;
MPI_Request		*reqs;
int			*index;
int			*flag;
MPI_Status		*stat;

{
	int		i;			/* favourite index */
	int		fl_done;		/* request done flag */
	int		err;			/* error code */
	int		fl_trace;		/* do tracing? */
	MPI_Comm	comm = 0;		/* communicator */
	
	lam_initerr();
	lam_setfunc(BLKMPITESTANY);

	if (count < 0) {
		return(lam_errfunc(MPI_COMM_WORLD, BLKMPITESTANY,
				lam_mkerr(MPI_ERR_COUNT, 0)));
	}

	if ((count > 0) && (reqs == 0)) {
		return(lam_errfunc(MPI_COMM_WORLD, BLKMPITESTANY,
				lam_mkerr(MPI_ERR_REQUEST, 0)));
	}

	if ((flag == 0) || (index == 0) || (stat == 0)) {
		return(lam_errfunc(MPI_COMM_WORLD, BLKMPITESTANY,
				lam_mkerr(MPI_ERR_ARG, 0)));
	}
/*
 * Generate a start wrapper trace.
 */
	fl_trace = ((_kio.ki_rtf & RTF_TRON) == RTF_TRON);

	if (fl_trace) {
		lam_tr_wrapstart(BLKMPITESTANY);
	}
/*
 * Loop testing all requests.
 * Skip inactive requests.
 */
	lam_emptystat(stat);

	*flag = 1;
	*index = MPI_UNDEFINED;
	err = MPI_SUCCESS;

	for (i = 0; i < count; ++i, ++reqs) {

		if ((*reqs == MPI_REQUEST_NULL) ||
			((*reqs)->rq_state == LAM_RQSINIT)) continue;

		*flag = 0;
		comm = (*reqs)->rq_comm;

		err = MPI_Test(reqs, &fl_done, stat);
		if (err != MPI_SUCCESS) break;

		if (fl_done) {
			*flag = 1;
			*index = i;
			break;
		}
	}
/*
 * Generate an end wrapper trace.
 */
	if (fl_trace) {
		lam_tr_wrapend(BLKMPITESTANY);
	}

	lam_resetfunc(BLKMPITESTANY);

	if (err != MPI_SUCCESS) {
		return(lam_errfunc(comm, BLKMPITESTANY, err));
	}

	return(MPI_SUCCESS);
}
