/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	RBD
 *
 *	$Id: topotest.c,v 6.1 96/11/23 22:54:44 nevin Rel $
 *
 *	Function:	- get topology assigned to communicator
 *	Accepts:	- communicator
 *			- ptr topology type
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>

int
MPI_Topo_test(comm, ptopo)

MPI_Comm		comm;
int			*ptopo;

{
	lam_initerr();
	lam_setfunc(BLKMPITOPOTEST);
/*
 * Check the arguments.
 */
	if (comm == MPI_COMM_NULL) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPITOPOTEST, lam_mkerr(MPI_ERR_COMM, 0)));
	}

	if (ptopo == 0) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPITOPOTEST, lam_mkerr(MPI_ERR_ARG, 0)));
	}

	*ptopo = comm->c_topo_type;

	lam_resetfunc(BLKMPITOPOTEST);
	return(MPI_SUCCESS);
}
