/*
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	RBD
 *
 *	$Id: tub.c,v 6.1 96/11/23 22:54:48 nevin Rel $
 *
 *	Function:	- return upper bound of datatype
 *	Accepts:	- datatype
 *			- upper bound (out)
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>

int
MPI_Type_ub(dtype, ub)

MPI_Datatype		dtype;
MPI_Aint		*ub;

{
	lam_initerr();
	lam_setfunc(BLKMPITUB);

	if (dtype == MPI_DATATYPE_NULL) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPITUB, lam_mkerr(MPI_ERR_TYPE, 0)));
	}
	else if (ub == 0) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPITUB, lam_mkerr(MPI_ERR_ARG, 0)));
	}
	else {
		*ub = dtype->dt_upper;
	}

	lam_resetfunc(BLKMPITUB);
	return(MPI_SUCCESS);
}
