/*
 *	Ohio Trollius
 *	Copyright 1995 The Ohio State University
 *	GDB/RBD
 *
 *	$Log:	frecv.c,v $
 * Revision 6.1  96/11/23  23:56:39  nevin
 * Ohio Release
 * 
 * Revision 6.0  96/02/29  13:58:07  gdburns
 * Ohio Release
 * 
 * Revision 5.2.1.1  96/01/16  12:20:33  gdburns
 * Pass all network flags to the kernel.
 * 
 * Revision 5.2  94/08/22  14:07:12  gdburns
 * Ohio Release
 * 
 * Revision 5.1.1.1  94/08/18  11:43:14  gdburns
 * upgrade for new kernel
 * 
 * Revision 5.1  94/05/18  12:52:54  gdburns
 * Ohio Release
 * 
 * Revision 2.3  94/04/22  12:44:08  gdburns
 * Ohio Release
 * 
 *	Function:	- forwarding datalink recv
 */

#include <net.h>

/*
 *	frecv
 *
 *	Function:	- receives a forwarded message at the datalink sublayer
 *			- the header is overwritten by the received message
 *	Accepts:	- network message descriptor
 *	Returns:	- 0 or ERROR
 */
int
frecv(nhead)

struct nmsg		*nhead;

{
	struct kmsg	khead;		/* kernel message descriptor */
/*
 * Set up kernel message descriptor to receive network frame header.
 */     
	khead.k_event = nhead->nh_event;
	khead.k_type = nhead->nh_type;
	khead.k_length = nhead->nh_length;
	khead.k_flags = KNMSG | nhead->nh_flags;
	khead.k_msg = (char *) nhead;
/*
 * Receive network frame header.
 */
	return(krecv(&khead));
}

/*
 *	frecvfront
 *
 *	Function:	- front half of frecv()
 *	Accepts:	- network message descriptor
 *	Returns:	- client-kernel socket or ERROR
 */
int
frecvfront(nhead)

struct nmsg		*nhead;

{
	struct kmsg	khead;		/* kernel message descriptor */
/*
 * Set up kernel message descriptor to receive network frame header.
 */     
	khead.k_event = nhead->nh_event;
	khead.k_type = nhead->nh_type;
	khead.k_length = nhead->nh_length;
	khead.k_flags = KNMSG | nhead->nh_flags;
	khead.k_msg = (char *) nhead;
/*
 * Receive network frame header.
 */
	return(krecvfront(&khead));
}

/*
 *	frecvback
 *
 *	Function:	- back half of frecv()
 *	Accepts:	- network message descriptor
 *	Returns:	- 0 or ERROR
 */
int
frecvback(nhead)

struct nmsg		*nhead;

{
	struct kmsg	khead;		/* kernel message descriptor */

	khead.k_flags = KNMSG | nhead->nh_flags;
	khead.k_msg = (char *) nhead;
	return(krecvback(&khead));
}
