/* vi:set ts=8 sts=0 sw=8:
 * $Id: debug.h,v 1.1 1998/10/08 18:54:39 kahn Exp kahn $
 *
 * Copyright (C) 1998 Andy C. Kahn <kahn@zk3.dec.com>
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef __DEBUG_H__
#define __DEBUG_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include <stdio.h>
#include "debug.h"

#ifdef GNP_DEBUG

extern long dbg_flags;

#define DBG_DIALOG	0x00000001
#define DBG_DOC		0x00000002
#define DBG_FILE	0x00000004
#define DBG_GENERIC	0x00000008
#define DBG_MSGBAR	0x00000010
#define DBG_MSGBOX	0x00000020
#define DBG_PREFS	0x00000040
#define DBG_PRINT	0x00000080
#define DBG_PROJECT	0x00000100
#define DBG_RECENT	0x00000200
#define DBG_SEARCH	0x00000400
#define DBG_TOOLBAR	0x00000800
#define DBG_WIN		0x00001000

#define DBG_PRINTF(options, s)	\
	if (dbg_flags & (options))	\
		printf s;

#define GNPDBG_ALWAYS(s)	printf s;
#define GNPDBG_DIALOG(s)	DBG_PRINTF(DBG_DIALOG,  s);
#define GNPDBG_DOC(s)		DBG_PRINTF(DBG_DOC,     s);
#define GNPDBG_FILE(s)		DBG_PRINTF(DBG_FILE,    s);
#define GNPDBG_GENERIC(s)	DBG_PRINTF(DBG_GENERIC, s);
#define GNPDBG_MSGBAR(s)	DBG_PRINTF(DBG_MSGBAR,  s);
#define GNPDBG_MSGBOX(s)	DBG_PRINTF(DBG_MSGBOX,  s);
#define GNPDBG_PREFS(s)		DBG_PRINTF(DBG_PREFS,   s);
#define GNPDBG_PRINT(s)		DBG_PRINTF(DBG_PRINT,   s);
#define GNPDBG_PROJECT(s)	DBG_PRINTF(DBG_PROJECT, s);
#define GNPDBG_RECENT(s)	DBG_PRINTF(DBG_RECENT,  s);
#define GNPDBG_SEARCH(s)	DBG_PRINTF(DBG_SEARCH,  s);
#define GNPDBG_TOOLBAR(s)	DBG_PRINTF(DBG_TOOLBAR, s);
#define GNPDBG_WIN(s)		DBG_PRINTF(DBG_WIN,     s);

#else	/* NO DEBUG */

#define DBG_PRINTF(options, s)

#define GNPDBG_ALWAYS(s)
#define GNPDBG_DIALOG(s)
#define GNPDBG_DOC(s)
#define GNPDBG_FILE(s)
#define GNPDBG_GENERIC(s)
#define GNPDBG_MSGBAR(s)
#define GNPDBG_MSGBOX(s)
#define GNPDBG_PREFS(s)
#define GNPDBG_PRINT(s)
#define GNPDBG_PROJECT(s)
#define GNPDBG_RECENT(s)
#define GNPDBG_SEARCH(s)
#define GNPDBG_TOOLBAR(s)
#define GNPDBG_WIN(s)

#endif	/* GNP_DEBUG */


#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif	/* __DEBUG_H__ */
