/* vi:set ts=8 sts=0 sw=8:
 * $Id: dialog.h,v 1.5 1998/10/05 15:29:33 kahn Exp kahn $
 *
 * Copyright (C) 1998 Andy C. Kahn <kahn@zk3.dec.com>
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef __DIALOG_H__
#define __DIALOG_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#include <gtk/gtk.h>

#define BUTTON_OK	"Ok"
#define BUTTON_CANCEL	"Cancel"
#define BUTTON_YES	"Yes"
#define BUTTON_NO	"No"
#define BUTTON_CLOSE	"Close"
#define BUTTON_APPLY	"Apply"
#define BUTTON_HELP	"Help"

#define DIALOG_YES	1
#define DIALOG_NO	2
#define DIALOG_CANCEL	3

extern int do_dialog_yes_no_cancel(char *title, char *msg);
extern int do_dialog_ok(char *title, char *msg);
extern int do_dialog(char *title, char *msg, short num, char **buttons,
	short dflt, GtkSignalFunc **cbs, void **cbd, bool_t block);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif	/* __DIALOG_H__ */
