/* vi:set ts=8 sts=0 sw=8:
 * $Id: file.h,v 1.8 1998/10/15 21:00:35 kahn Exp kahn $
 *
 * Copyright (C) 1998 Andy C. Kahn <kahn@zk3.dec.com>
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef __FILE_H__
#define __FILE_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include <stdio.h>
#include <sys/stat.h>
#include "main.h"
#include "win.h"
#include "doc.h"

extern bool_t file_exist(char *fname);
extern int file_open_execute(win_t *w, doc_t *d);
extern char *file_perm_string(struct stat *sb);
extern bool_t file_save_execute(doc_t *d);
extern char * file_full_pathname_make(char *fname);
extern int file_unlock(const char *path, FILE *fp);
extern int file_lock(const char *, FILE *fp, bool_t, bool_t, bool_t);
extern bool_t file_is_readonly(char *fname);


#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif	/* __FILE_H__ */
