# Makefile for the CLISP binaries
# DO NOT EDIT! GENERATED AUTOMATICALLY!
# This file was created on host linuix.mathematik.uni-karlsruhe.de as the output of the command:
# ./makemake acorn ansi

# -------------- Start of configurable section --------------------

# Directories used by "make install":
prefix = 
exec_prefix = $(prefix)
bindir = $(exec_prefix).bin
mandir = $(exec_prefix).man
libdir = $(exec_prefix).lib
lisplibdir = $(libdir).lisp

# List of add-on modules:
# stdwin               the stdwin library as a separate module
# queens               the queens function as a separate module
MODULES = 

# Programs used by "make":
CC = cc
CFLAGS =  -D__arm -D__riscos -wanp -throwback -JUnix: -IUnix:
CPP = cc -E
CLFLAGS =  -LUnix:o.Unixlib
LIBS = 
X_LIBS = 

MAKE = make
RM = remove
CP = cp ~A~CNF
LN = cp ~A~CNF
MV = cp ~A~CDF
CAT = cat
TOUCH = touch
GREP = egrep
SED = sed
AR = ar
RANLIB = ranlib

# Programs used by "make install":
INSTALL = cp ~A~CNF
INSTALL_PROGRAM = $(INSTALL)
INSTALL_DATA = $(INSTALL)

# Programs used by "make distrib":

# formatter for manual page
ROFF_MAN = xfmt -m # try "groff -Tascii -mandoc" or "nroff -man"
ROFF_DVI =  # try "groff -Tdvi -mandoc"

# -------------- End of configurable section --------------------

# 
#                       Requirements for add-on modules
#                       -------------------------------
# 
# The general layout of add-on modules is described in ^.doc/module.txt.
# The requirements made there (i.e. the existence of a "link.sh" file
# which defines certain variables) make sure that such an add-on module
# can be distributed with CLISP.
# 
# If you want an add-on module to be _built_ automatically with CLISP,
# the following additional requirements have to be obeyed.
# 
#   1. The module must be located in a subdirectory of clisp's source
#      directory.
#      Examples: clisp/src/ wildcard/
#                clisp/src/ bindings/linux/
# 
#   2. If the module contains a file called "configure", it is assumed
#      to be a GNU autoconf generated configuration file, and is called
#      with a "--cache-file=..." argument. It should generate platform
#      dependent header files, Makefiles and the like.
# 
#   3. The module should contain a Makefile (maybe generated by requirement 2),
#      which defines the following targets:
# 
#        clisp-module
# 
#           This target builds the file mentioned by the link.sh file.
#           The following makefile variables can be used:
#             CC                 the C compiler used to compile the CLISP source
#             CFLAGS             the C compiler flags
#             INCLUDES           a directory containing CLISP header files
#             LISPBIBL_INCLUDES  if you #include "lispbibl.c", put this onto
#                                the dependency line
#             CLFLAGS            the C compiler flags when linking an executable
#             LIBS               the libraries used when linking an executable
#             RANLIB             the name of the "ranlib" command
#             CLISP              a command which calls the already built
#                                "base" clisp.
#           Typically, you will have rules like this in your Makefile:
#               o.foo : c.foo
#                       $(CC) $(CFLAGS) -I$(INCLUDES) -c c.foo
#               fas.foo : lsp.foo
#                       $(CLISP) -c foo.lsp
# 
#        clisp-module-wide
# 
#           This target does the same as clisp-module, plus it builds the
#           object files in wide mode as well.
#           Typically, you will have rules like this in your Makefile:
#               o.wfoo : c.foo
#                       $(CC) $(CFLAGS) -DWIDE -I$(INCLUDES) -c c.foo -o o.wfoo
# 
#        clisp-module-distrib
# 
#           This target copies the module into a temporary distribution
#           directory, on the same disk.
#           The following makefile variables can be used:
#             distribdir       the name of temporary distribution directory
#             LN               command to make hard links (works also for
#                              symbolic links)
#           Typically, this target will look like this:
#
#               DISTRIBFILES = <the non-wide NEW_FILES mentioned in link.sh> \
#                              <doc files>
#               clisp-module-distrib : clisp-module force
#                       $(LN) $(DISTRIBFILES) $(distribdir)
# 
#        clisp-module-distrib-wide
# 
#           This target does the same as clisp-module-distrib, but including
#           the wide mode object files.
#           Typically, this target will look like this:
#
#               WDISTRIBFILES = $(DISTRIBFILES) <the wide NEW_FILES in link.sh>
#               clisp-module-distrib-wide : clisp-module-wide force
#                       $(LN) $(WDISTRIBFILES) $(distribdir)
# 
# If these requirements are obeyed, this Makefile will automatically build
# the add-on module and make it part of the "full" distribution -- all you
# need to do is to add its name to the MODULES definition line above.
# 

COMMENT5 = /@.comment5
ANSIDECL = /@.ansidecl
TXT2C = /@.txt2c -I^.

DFILES = \
d.spvw \
d.spvwtabf \
d.spvwtabs \
d.spvwtabo \
d.eval \
d.control \
d.pathname \
d.stream \
d.io \
d.array \
d.hashtabl \
d.list \
d.package \
d.record \
d.sequence \
d.charstrg \
d.debug \
d.error \
d.misc \
d.time \
d.predtype \
d.symbol \
d.lisparit \
d.unixaux \
d.acornaux \
d.acornsig \
d.lispbibl \
d.fsubr \
d.subr \
d.pseudofun \
d.constsym \
d.constobj \
d.acorn \
d.constpack \
d.avl \
d.sort \
d.subrkw \
d.bytecode \
d.errunix \
d.aridecl \
d.arilev0 \
d.arilev1 \
d.intelem \
d.intlog \
d.intplus \
d.intcomp \
d.intbyte \
d.intmal \
d.intdiv \
d.intgcd \
d.int2adic \
d.intsqrt \
d.intprint \
d.intread \
d.rational \
d.sfloat \
d.ffloat \
d.dfloat \
d.lfloat \
d.flo_konv \
d.flo_rest \
d.realelem \
d.realrand \
d.realtran \
d.compelem \
d.comptran \
d.arilev1c \
d.arilev1e \
d.arilev1i \
d.genclisph \
d.modules \
d.noreadline \
d.ariarm

CFILES = \
c.spvw \
c.spvwtabf \
c.spvwtabs \
c.spvwtabo \
c.eval \
c.control \
c.pathname \
c.stream \
c.io \
c.array \
c.hashtabl \
c.list \
c.package \
c.record \
c.sequence \
c.charstrg \
c.debug \
c.error \
c.misc \
c.time \
c.predtype \
c.symbol \
c.lisparit \
c.unixaux \
c.acornaux \
c.acornsig \
c.lispbibl \
c.fsubr \
c.subr \
c.pseudofun \
c.constsym \
c.constobj \
c.acorn \
c.constpack \
c.avl \
c.sort \
c.subrkw \
c.bytecode \
c.errunix \
c.aridecl \
c.arilev0 \
c.arilev1 \
c.intelem \
c.intlog \
c.intplus \
c.intcomp \
c.intbyte \
c.intmal \
c.intdiv \
c.intgcd \
c.int2adic \
c.intsqrt \
c.intprint \
c.intread \
c.rational \
c.sfloat \
c.ffloat \
c.dfloat \
c.lfloat \
c.flo_konv \
c.flo_rest \
c.realelem \
c.realrand \
c.realtran \
c.compelem \
c.comptran \
c.arilev1c \
c.arilev1e \
c.arilev1i \
c.genclisph \
c.modules \
c.noreadline \
c.ariarm

OBJECTS = \
o.spvw \
o.spvwtabf \
o.spvwtabs \
o.spvwtabo \
o.eval \
o.control \
o.pathname \
o.stream \
o.io \
o.array \
o.hashtabl \
o.list \
o.package \
o.record \
o.sequence \
o.charstrg \
o.debug \
o.error \
o.misc \
o.time \
o.predtype \
o.symbol \
o.lisparit \
o.unixaux \
o.acornaux \
o.acornsig \
o.ariarm

LSPFILES = \
lsp.init \
lsp.defseq \
lsp.backquot \
lsp.defmacro \
lsp.macros1 \
lsp.macros2 \
lsp.defs1 \
lsp.timezone \
lsp.places \
lsp.floatpri \
lsp.type \
lsp.defstruc \
lsp.format \
lsp.user1 \
lsp.user2 \
lsp.trace \
lsp.macros3 \
lsp.config \
lsp.compiler \
lsp.disassem \
lsp.defs2 \
lsp.loop \
lsp.clos \
lsp.conditio \
lsp.defs3 \
lsp.gstream \
lsp.foreign1 \
lsp.screen \
lsp.rexx1 \
lsp.editor \
lsp.spanish

FASFILES = \
fas.init \
fas.defseq \
fas.backquot \
fas.defmacro \
fas.macros1 \
fas.macros2 \
fas.defs1 \
fas.timezone \
fas.places \
fas.floatpri \
fas.type \
fas.defstruc \
fas.format \
fas.user1 \
fas.user2 \
fas.trace \
fas.macros3 \
fas.config \
fas.compiler \
fas.disassem \
fas.defs2 \
fas.loop \
fas.clos \
fas.conditio \
fas.defs3 \
fas.gstream \
fas.foreign1 \
fas.screen \
fas.rexx1 \
fas.editor \
fas.spanish

TXTFILES = \
txt.LISP-tutorial \
txt.CLOS-guide \
txt.cltl2 \
txt.editors

TESTLSPFILES = \
stage.lsp.init \
stage.lsp.defseq \
stage.lsp.backquot \
stage.lsp.defmacro \
stage.lsp.macros1 \
stage.lsp.macros2 \
stage.lsp.defs1 \
stage.lsp.timezone \
stage.lsp.places \
stage.lsp.floatpri \
stage.lsp.type \
stage.lsp.defstruc \
stage.lsp.format \
stage.lsp.user1 \
stage.lsp.user2 \
stage.lsp.trace \
stage.lsp.macros3 \
stage.lsp.config \
stage.lsp.compiler \
stage.lsp.disassem \
stage.lsp.defs2 \
stage.lsp.loop \
stage.lsp.clos \
stage.lsp.conditio \
stage.lsp.defs3 \
stage.lsp.gstream \
stage.lsp.foreign1 \
stage.lsp.screen \
stage.lsp.rexx1 \
stage.lsp.editor \
stage.lsp.spanish

TESTFASFILES = \
stage.fas.init \
stage.fas.defseq \
stage.fas.backquot \
stage.fas.defmacro \
stage.fas.macros1 \
stage.fas.macros2 \
stage.fas.defs1 \
stage.fas.timezone \
stage.fas.places \
stage.fas.floatpri \
stage.fas.type \
stage.fas.defstruc \
stage.fas.format \
stage.fas.user1 \
stage.fas.user2 \
stage.fas.trace \
stage.fas.macros3 \
stage.fas.config \
stage.fas.compiler \
stage.fas.disassem \
stage.fas.defs2 \
stage.fas.loop \
stage.fas.clos \
stage.fas.conditio \
stage.fas.defs3 \
stage.fas.gstream \
stage.fas.foreign1 \
stage.fas.screen \
stage.fas.rexx1 \
stage.fas.editor \
stage.fas.spanish


# The Acorn Make Utility has problems with halfcomp.mem.
# If you have this problem, either swap mem.halfcomp and mem.lispinit in the next line, or use GNU make.
all : init allc allo lisp mem.interpre mem.halfcomp mem.lispinit manual
	$(TOUCH) all


init : comment5 ansidecl txt2c ccmp2c $(DFILES) h.modules
	$(TOUCH) init

comment5 : ^.utils.c.comment5
	$(CC) $(CFLAGS) $(CLFLAGS) ^.utils.c.comment5 -o comment5

ansidecl : ^.utils.d.ansidecl comment5
	$(LN) ^.utils.d.ansidecl d.ansidecl
	$(COMMENT5) ansidecl.d ansidecl.c
	$(RM) d.ansidecl
	$(CC) $(CFLAGS) $(CLFLAGS) c.ansidecl -o ansidecl
	$(RM) c.ansidecl

txt2c : ^.utils.c.txt2c ansidecl
	$(ANSIDECL) < ^.utils.c.txt2c > txt2c.c
	$(CC) $(CFLAGS) $(CLFLAGS) c.txt2c -o txt2c
	$(RM) c.txt2c

ccmp2c : ^.utils.d.ccmp2c comment5 ansidecl
	$(COMMENT5) ^.utils.d.ccmp2c > TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > ccmp2c.c
	$(RM) TMPPIPE1
	$(CC) $(CFLAGS) $(CLFLAGS) -I. c.ccmp2c -o ccmp2c
	$(RM) c.ccmp2c


allc : init $(CFILES)
	$(TOUCH) allc

c.spvw : d.spvw comment5 ansidecl
	$(COMMENT5) spvw.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > spvw.c
	$(RM) TMPPIPE1

c.spvwtabf : d.spvwtabf comment5 ansidecl
	$(COMMENT5) spvwtabf.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > spvwtabf.c
	$(RM) TMPPIPE1

c.spvwtabs : d.spvwtabs comment5 ansidecl
	$(COMMENT5) spvwtabs.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > spvwtabs.c
	$(RM) TMPPIPE1

c.spvwtabo : d.spvwtabo comment5 ansidecl
	$(COMMENT5) spvwtabo.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > spvwtabo.c
	$(RM) TMPPIPE1

c.eval : d.eval comment5 ansidecl
	$(COMMENT5) eval.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > eval.c
	$(RM) TMPPIPE1

c.control : d.control comment5 ansidecl
	$(COMMENT5) control.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > control.c
	$(RM) TMPPIPE1

c.pathname : d.pathname comment5 ansidecl
	$(COMMENT5) pathname.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > pathname.c
	$(RM) TMPPIPE1

c.stream : d.stream comment5 ansidecl
	$(COMMENT5) stream.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > stream.c
	$(RM) TMPPIPE1

c.io : d.io comment5 ansidecl
	$(COMMENT5) io.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > io.c
	$(RM) TMPPIPE1

c.array : d.array comment5 ansidecl
	$(COMMENT5) array.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > array.c
	$(RM) TMPPIPE1

c.hashtabl : d.hashtabl comment5 ansidecl
	$(COMMENT5) hashtabl.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > hashtabl.c
	$(RM) TMPPIPE1

c.list : d.list comment5 ansidecl
	$(COMMENT5) list.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > list.c
	$(RM) TMPPIPE1

c.package : d.package comment5 ansidecl
	$(COMMENT5) package.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > package.c
	$(RM) TMPPIPE1

c.record : d.record comment5 ansidecl
	$(COMMENT5) record.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > record.c
	$(RM) TMPPIPE1

c.sequence : d.sequence comment5 ansidecl
	$(COMMENT5) sequence.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > sequence.c
	$(RM) TMPPIPE1

c.charstrg : d.charstrg comment5 ansidecl
	$(COMMENT5) charstrg.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > charstrg.c
	$(RM) TMPPIPE1

c.debug : d.debug comment5 ansidecl
	$(COMMENT5) debug.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > debug.c
	$(RM) TMPPIPE1

c.error : d.error comment5 ansidecl
	$(COMMENT5) error.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > error.c
	$(RM) TMPPIPE1

c.misc : d.misc comment5 ansidecl
	$(COMMENT5) misc.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > misc.c
	$(RM) TMPPIPE1

c.time : d.time comment5 ansidecl
	$(COMMENT5) time.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > time.c
	$(RM) TMPPIPE1

c.predtype : d.predtype comment5 ansidecl
	$(COMMENT5) predtype.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > predtype.c
	$(RM) TMPPIPE1

c.symbol : d.symbol comment5 ansidecl
	$(COMMENT5) symbol.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > symbol.c
	$(RM) TMPPIPE1

c.lisparit : d.lisparit comment5 ansidecl
	$(COMMENT5) lisparit.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > lisparit.c
	$(RM) TMPPIPE1

c.unixaux : d.unixaux comment5 ansidecl
	$(COMMENT5) unixaux.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > unixaux.c
	$(RM) TMPPIPE1

c.acornaux : d.acornaux comment5 ansidecl
	$(COMMENT5) acornaux.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > acornaux.c
	$(RM) TMPPIPE1

c.acornsig : d.acornsig comment5 ansidecl
	$(COMMENT5) acornsig.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > acornsig.c
	$(RM) TMPPIPE1

c.lispbibl : d.lispbibl comment5 ansidecl
	$(COMMENT5) lispbibl.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > lispbibl.c
	$(RM) TMPPIPE1

c.fsubr : d.fsubr comment5 ansidecl
	$(COMMENT5) fsubr.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > fsubr.c
	$(RM) TMPPIPE1

c.subr : d.subr comment5 ansidecl
	$(COMMENT5) subr.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > subr.c
	$(RM) TMPPIPE1

c.pseudofun : d.pseudofun comment5 ansidecl
	$(COMMENT5) pseudofun.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > pseudofun.c
	$(RM) TMPPIPE1

c.constsym : d.constsym comment5 ansidecl
	$(COMMENT5) constsym.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > constsym.c
	$(RM) TMPPIPE1

c.constobj : d.constobj comment5 ansidecl
	$(COMMENT5) constobj.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > constobj.c
	$(RM) TMPPIPE1

c.acorn : d.acorn comment5 ansidecl
	$(COMMENT5) acorn.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > acorn.c
	$(RM) TMPPIPE1

c.constpack : d.constpack comment5 ansidecl
	$(COMMENT5) constpack.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > constpack.c
	$(RM) TMPPIPE1

c.avl : d.avl comment5 ansidecl
	$(COMMENT5) avl.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > avl.c
	$(RM) TMPPIPE1

c.sort : d.sort comment5 ansidecl
	$(COMMENT5) sort.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > sort.c
	$(RM) TMPPIPE1

c.subrkw : d.subrkw comment5 ansidecl
	$(COMMENT5) subrkw.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > subrkw.c
	$(RM) TMPPIPE1

c.bytecode : d.bytecode comment5 ansidecl
	$(COMMENT5) bytecode.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > bytecode.c
	$(RM) TMPPIPE1

c.errunix : d.errunix comment5 ansidecl
	$(COMMENT5) errunix.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > errunix.c
	$(RM) TMPPIPE1

c.aridecl : d.aridecl comment5 ansidecl
	$(COMMENT5) aridecl.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > aridecl.c
	$(RM) TMPPIPE1

c.arilev0 : d.arilev0 comment5 ansidecl
	$(COMMENT5) arilev0.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > arilev0.c
	$(RM) TMPPIPE1

c.arilev1 : d.arilev1 comment5 ansidecl
	$(COMMENT5) arilev1.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > arilev1.c
	$(RM) TMPPIPE1

c.intelem : d.intelem comment5 ansidecl
	$(COMMENT5) intelem.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > intelem.c
	$(RM) TMPPIPE1

c.intlog : d.intlog comment5 ansidecl
	$(COMMENT5) intlog.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > intlog.c
	$(RM) TMPPIPE1

c.intplus : d.intplus comment5 ansidecl
	$(COMMENT5) intplus.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > intplus.c
	$(RM) TMPPIPE1

c.intcomp : d.intcomp comment5 ansidecl
	$(COMMENT5) intcomp.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > intcomp.c
	$(RM) TMPPIPE1

c.intbyte : d.intbyte comment5 ansidecl
	$(COMMENT5) intbyte.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > intbyte.c
	$(RM) TMPPIPE1

c.intmal : d.intmal comment5 ansidecl
	$(COMMENT5) intmal.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > intmal.c
	$(RM) TMPPIPE1

c.intdiv : d.intdiv comment5 ansidecl
	$(COMMENT5) intdiv.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > intdiv.c
	$(RM) TMPPIPE1

c.intgcd : d.intgcd comment5 ansidecl
	$(COMMENT5) intgcd.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > intgcd.c
	$(RM) TMPPIPE1

c.int2adic : d.int2adic comment5 ansidecl
	$(COMMENT5) int2adic.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > int2adic.c
	$(RM) TMPPIPE1

c.intsqrt : d.intsqrt comment5 ansidecl
	$(COMMENT5) intsqrt.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > intsqrt.c
	$(RM) TMPPIPE1

c.intprint : d.intprint comment5 ansidecl
	$(COMMENT5) intprint.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > intprint.c
	$(RM) TMPPIPE1

c.intread : d.intread comment5 ansidecl
	$(COMMENT5) intread.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > intread.c
	$(RM) TMPPIPE1

c.rational : d.rational comment5 ansidecl
	$(COMMENT5) rational.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > rational.c
	$(RM) TMPPIPE1

c.sfloat : d.sfloat comment5 ansidecl
	$(COMMENT5) sfloat.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > sfloat.c
	$(RM) TMPPIPE1

c.ffloat : d.ffloat comment5 ansidecl
	$(COMMENT5) ffloat.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > ffloat.c
	$(RM) TMPPIPE1

c.dfloat : d.dfloat comment5 ansidecl
	$(COMMENT5) dfloat.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > dfloat.c
	$(RM) TMPPIPE1

c.lfloat : d.lfloat comment5 ansidecl
	$(COMMENT5) lfloat.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > lfloat.c
	$(RM) TMPPIPE1

c.flo_konv : d.flo_konv comment5 ansidecl
	$(COMMENT5) flo_konv.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > flo_konv.c
	$(RM) TMPPIPE1

c.flo_rest : d.flo_rest comment5 ansidecl
	$(COMMENT5) flo_rest.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > flo_rest.c
	$(RM) TMPPIPE1

c.realelem : d.realelem comment5 ansidecl
	$(COMMENT5) realelem.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > realelem.c
	$(RM) TMPPIPE1

c.realrand : d.realrand comment5 ansidecl
	$(COMMENT5) realrand.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > realrand.c
	$(RM) TMPPIPE1

c.realtran : d.realtran comment5 ansidecl
	$(COMMENT5) realtran.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > realtran.c
	$(RM) TMPPIPE1

c.compelem : d.compelem comment5 ansidecl
	$(COMMENT5) compelem.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > compelem.c
	$(RM) TMPPIPE1

c.comptran : d.comptran comment5 ansidecl
	$(COMMENT5) comptran.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > comptran.c
	$(RM) TMPPIPE1

c.arilev1c : d.arilev1c comment5 ansidecl
	$(COMMENT5) arilev1c.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > arilev1c.c
	$(RM) TMPPIPE1

c.arilev1e : d.arilev1e comment5 ansidecl
	$(COMMENT5) arilev1e.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > arilev1e.c
	$(RM) TMPPIPE1

c.arilev1i : d.arilev1i comment5 ansidecl
	$(COMMENT5) arilev1i.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > arilev1i.c
	$(RM) TMPPIPE1

c.genclisph : d.genclisph comment5 ansidecl
	$(COMMENT5) genclisph.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > genclisph.c
	$(RM) TMPPIPE1

c.modules : d.modules comment5 ansidecl
	$(COMMENT5) modules.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > modules.c
	$(RM) TMPPIPE1

c.noreadline : d.noreadline comment5 ansidecl
	$(COMMENT5) noreadline.d TMPPIPE1
	$(ANSIDECL) < TMPPIPE1 > noreadline.c
	$(RM) TMPPIPE1

c.ariarm : d.ariarm comment5  
	$(COMMENT5) ariarm.d ariarm.c

s.ariarm : c.ariarm
	$(CPP) c.ariarm > TMPPIPE1
	$(SED) -f ^.acorn.sed.asmfilter < TMPPIPE1 > s.ariarm
	$(RM) TMPPIPE1

allo : allc o.spvw o.spvwtabf o.spvwtabs o.spvwtabo o.eval o.control o.pathname o.stream o.io o.array o.hashtabl o.list o.package o.record o.sequence o.charstrg o.debug o.error o.misc o.time o.predtype o.symbol o.lisparit o.unixaux o.acornaux o.acornsig
	$(TOUCH) allo

alls : allc s.spvw s.spvwtabf s.spvwtabs s.spvwtabo s.eval s.control s.pathname s.stream s.io s.array s.hashtabl s.list s.package s.record s.sequence s.charstrg s.debug s.error s.misc s.time s.predtype s.symbol s.lisparit s.unixaux s.acornaux s.acornsig
	$(TOUCH) alls

# Normally not used (just for debugging).
alli : allc i.spvw i.spvwtabf i.spvwtabs i.spvwtabo i.eval i.control i.pathname i.stream i.io i.array i.hashtabl i.list i.package i.record i.sequence i.charstrg i.debug i.error i.misc i.time i.predtype i.symbol i.lisparit i.unixaux i.acornaux i.acornsig
	$(TOUCH) alli

i.spvw : c.spvw c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn c.constpack c.avl c.sort c.subrkw c.arilev0 c.aridecl h.version
	$(CPP) $(CFLAGS) c.spvw > i.spvw

s.spvw : c.spvw c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn c.constpack c.avl c.sort c.subrkw c.arilev0 c.aridecl h.version
	$(CC) $(CFLAGS) -S c.spvw

o.spvw : c.spvw c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn c.constpack c.avl c.sort c.subrkw c.arilev0 c.aridecl h.version
	$(CC) $(CFLAGS) -c c.spvw

i.spvwtabf : c.spvwtabf c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn
	$(CPP) $(CFLAGS) c.spvwtabf > i.spvwtabf

s.spvwtabf : c.spvwtabf c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn
	$(CC) $(CFLAGS) -S c.spvwtabf

o.spvwtabf : c.spvwtabf c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn
	$(CC) $(CFLAGS) -c c.spvwtabf

i.spvwtabs : c.spvwtabs c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn
	$(CPP) $(CFLAGS) c.spvwtabs > i.spvwtabs

s.spvwtabs : c.spvwtabs c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn
	$(CC) $(CFLAGS) -S c.spvwtabs

o.spvwtabs : c.spvwtabs c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn
	$(CC) $(CFLAGS) -c c.spvwtabs

i.spvwtabo : c.spvwtabo c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn
	$(CPP) $(CFLAGS) c.spvwtabo > i.spvwtabo

s.spvwtabo : c.spvwtabo c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn
	$(CC) $(CFLAGS) -S c.spvwtabo

o.spvwtabo : c.spvwtabo c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn
	$(CC) $(CFLAGS) -c c.spvwtabo

i.eval : c.eval c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn c.bytecode
	$(CPP) $(CFLAGS) c.eval > i.eval

s.eval : c.eval c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn c.bytecode
	$(CC) $(CFLAGS) -S c.eval

o.eval : c.eval c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn c.bytecode
	$(CC) $(CFLAGS) -c c.eval

i.control : c.control c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn
	$(CPP) $(CFLAGS) c.control > i.control

s.control : c.control c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn
	$(CC) $(CFLAGS) -S c.control

o.control : c.control c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn
	$(CC) $(CFLAGS) -c c.control

i.pathname : c.pathname c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn
	$(CPP) $(CFLAGS) c.pathname > i.pathname

s.pathname : c.pathname c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn
	$(CC) $(CFLAGS) -S c.pathname

o.pathname : c.pathname c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn
	$(CC) $(CFLAGS) -c c.pathname

i.stream : c.stream c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn c.arilev0
	$(CPP) $(CFLAGS) c.stream > i.stream

s.stream : c.stream c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn c.arilev0
	$(CC) $(CFLAGS) -S c.stream

o.stream : c.stream c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn c.arilev0
	$(CC) $(CFLAGS) -c c.stream

i.io : c.io c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn c.arilev0
	$(CPP) $(CFLAGS) c.io > i.io

s.io : c.io c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn c.arilev0
	$(CC) $(CFLAGS) -S c.io

o.io : c.io c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn c.arilev0
	$(CC) $(CFLAGS) -c c.io

i.array : c.array c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn c.arilev0
	$(CPP) $(CFLAGS) c.array > i.array

s.array : c.array c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn c.arilev0
	$(CC) $(CFLAGS) -S c.array

o.array : c.array c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn c.arilev0
	$(CC) $(CFLAGS) -c c.array

i.hashtabl : c.hashtabl c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn c.arilev0 c.aridecl
	$(CPP) $(CFLAGS) c.hashtabl > i.hashtabl

s.hashtabl : c.hashtabl c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn c.arilev0 c.aridecl
	$(CC) $(CFLAGS) -S c.hashtabl

o.hashtabl : c.hashtabl c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn c.arilev0 c.aridecl
	$(CC) $(CFLAGS) -c c.hashtabl

i.list : c.list c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn
	$(CPP) $(CFLAGS) c.list > i.list

s.list : c.list c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn
	$(CC) $(CFLAGS) -S c.list

o.list : c.list c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn
	$(CC) $(CFLAGS) -c c.list

i.package : c.package c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn c.constpack c.arilev0
	$(CPP) $(CFLAGS) c.package > i.package

s.package : c.package c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn c.constpack c.arilev0
	$(CC) $(CFLAGS) -S c.package

o.package : c.package c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn c.constpack c.arilev0
	$(CC) $(CFLAGS) -c c.package

i.record : c.record c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn
	$(CPP) $(CFLAGS) c.record > i.record

s.record : c.record c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn
	$(CC) $(CFLAGS) -S c.record

o.record : c.record c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn
	$(CC) $(CFLAGS) -c c.record

i.sequence : c.sequence c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn
	$(CPP) $(CFLAGS) c.sequence > i.sequence

s.sequence : c.sequence c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn
	$(CC) $(CFLAGS) -S c.sequence

o.sequence : c.sequence c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn
	$(CC) $(CFLAGS) -c c.sequence

i.charstrg : c.charstrg c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn
	$(CPP) $(CFLAGS) c.charstrg > i.charstrg

s.charstrg : c.charstrg c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn
	$(CC) $(CFLAGS) -S c.charstrg

o.charstrg : c.charstrg c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn
	$(CC) $(CFLAGS) -c c.charstrg

i.debug : c.debug c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn
	$(CPP) $(CFLAGS) c.debug > i.debug

s.debug : c.debug c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn
	$(CC) $(CFLAGS) -S c.debug

o.debug : c.debug c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn
	$(CC) $(CFLAGS) -c c.debug

i.error : c.error c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn c.errunix
	$(CPP) $(CFLAGS) c.error > i.error

s.error : c.error c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn c.errunix
	$(CC) $(CFLAGS) -S c.error

o.error : c.error c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn c.errunix
	$(CC) $(CFLAGS) -c c.error

i.misc : c.misc c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn
	$(CPP) $(CFLAGS) c.misc > i.misc

s.misc : c.misc c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn
	$(CC) $(CFLAGS) -S c.misc

o.misc : c.misc c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn
	$(CC) $(CFLAGS) -c c.misc

i.time : c.time c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn c.arilev0
	$(CPP) $(CFLAGS) c.time > i.time

s.time : c.time c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn c.arilev0
	$(CC) $(CFLAGS) -S c.time

o.time : c.time c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn c.arilev0
	$(CC) $(CFLAGS) -c c.time

i.predtype : c.predtype c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn c.avl
	$(CPP) $(CFLAGS) c.predtype > i.predtype

s.predtype : c.predtype c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn c.avl
	$(CC) $(CFLAGS) -S c.predtype

o.predtype : c.predtype c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn c.avl
	$(CC) $(CFLAGS) -c c.predtype

i.symbol : c.symbol c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn
	$(CPP) $(CFLAGS) c.symbol > i.symbol

s.symbol : c.symbol c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn
	$(CC) $(CFLAGS) -S c.symbol

o.symbol : c.symbol c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn
	$(CC) $(CFLAGS) -c c.symbol

i.lisparit : c.lisparit c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn c.aridecl c.arilev0 c.arilev1 c.intelem c.intlog c.intplus c.intcomp c.intbyte c.intmal c.intdiv c.intgcd c.int2adic c.intsqrt c.intprint c.intread c.rational c.sfloat c.ffloat c.dfloat c.lfloat c.flo_konv c.flo_rest c.realelem c.realrand c.realtran c.compelem c.comptran c.arilev1c c.arilev1e c.arilev1i c.ariarm
	$(CPP) $(CFLAGS) c.lisparit > i.lisparit

s.lisparit : c.lisparit c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn c.aridecl c.arilev0 c.arilev1 c.intelem c.intlog c.intplus c.intcomp c.intbyte c.intmal c.intdiv c.intgcd c.int2adic c.intsqrt c.intprint c.intread c.rational c.sfloat c.ffloat c.dfloat c.lfloat c.flo_konv c.flo_rest c.realelem c.realrand c.realtran c.compelem c.comptran c.arilev1c c.arilev1e c.arilev1i c.ariarm
	$(CC) $(CFLAGS) -S c.lisparit

o.lisparit : c.lisparit c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn c.aridecl c.arilev0 c.arilev1 c.intelem c.intlog c.intplus c.intcomp c.intbyte c.intmal c.intdiv c.intgcd c.int2adic c.intsqrt c.intprint c.intread c.rational c.sfloat c.ffloat c.dfloat c.lfloat c.flo_konv c.flo_rest c.realelem c.realrand c.realtran c.compelem c.comptran c.arilev1c c.arilev1e c.arilev1i c.ariarm
	$(CC) $(CFLAGS) -c c.lisparit

i.unixaux : c.unixaux c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn
	$(CPP) $(CFLAGS) c.unixaux > i.unixaux

s.unixaux : c.unixaux c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn
	$(CC) $(CFLAGS) -S c.unixaux

o.unixaux : c.unixaux c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn
	$(CC) $(CFLAGS) -c c.unixaux

i.acornaux : c.acornaux c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn
	$(CPP) $(CFLAGS) c.acornaux > i.acornaux

s.acornaux : c.acornaux c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn
	$(CC) $(CFLAGS) -S c.acornaux

o.acornaux : c.acornaux c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn
	$(CC) $(CFLAGS) -c c.acornaux

i.acornsig : c.acornsig c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn
	$(CPP) $(CFLAGS) c.acornsig > i.acornsig

s.acornsig : c.acornsig c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn
	$(CC) $(CFLAGS) -S c.acornsig

o.acornsig : c.acornsig c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn
	$(CC) $(CFLAGS) -c c.acornsig

i.genclisph : c.genclisph c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn
	$(CPP) $(CFLAGS) c.genclisph > i.genclisph

s.genclisph : c.genclisph c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn
	$(CC) $(CFLAGS) -S c.genclisph

o.genclisph : c.genclisph c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn
	$(CC) $(CFLAGS) -c c.genclisph

i.modules : c.modules c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn h.modules
	$(CPP) $(CFLAGS) -DNO_CLISP_H c.modules > i.modules

s.modules : c.modules c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn h.modules
	$(CC) $(CFLAGS) -DNO_CLISP_H -S c.modules

o.modules : c.modules c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn h.modules
	$(CC) $(CFLAGS) -DNO_CLISP_H -c c.modules

i.noreadline : c.noreadline c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn
	$(CPP) $(CFLAGS) c.noreadline > i.noreadline

s.noreadline : c.noreadline c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn
	$(CC) $(CFLAGS) -S c.noreadline

o.noreadline : c.noreadline c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn
	$(CC) $(CFLAGS) -c c.noreadline

o.ariarm : s.ariarm
	objasm -Stamp -Quit -CloseExec -from s.ariarm -o o.ariarm

lisp : $(OBJECTS) o.modules     
	$(CC) $(CFLAGS) $(CLFLAGS) $(OBJECTS) o.modules $(LIBS) $(X_LIBS) -o lisp


alllsp : $(LSPFILES)
	$(TOUCH) alllsp

lsp.config : lsp.cfgacorn
	$(CP) lsp.cfgacorn lsp.config

mem.interpre : lisp $(LSPFILES)
	-$(RM) mem.interpre
	/@.lisp -m 750KW -x "(load \"init.lsp\") (sys::%saveinitmem) (exit)"
	$(MV) mem.lispimag mem.interpre

fas.init : lsp.init lisp mem.interpre
	/@.lisp -m 1000KW -M mem.interpre -q -c init.lsp

fas.defseq : lsp.defseq lisp mem.interpre
	/@.lisp -m 1000KW -M mem.interpre -q -c defseq.lsp

fas.backquot : lsp.backquot lisp mem.interpre
	/@.lisp -m 1000KW -M mem.interpre -q -c backquot.lsp

fas.defmacro : lsp.defmacro lisp mem.interpre
	/@.lisp -m 1000KW -M mem.interpre -q -c defmacro.lsp

fas.macros1 : lsp.macros1 lisp mem.interpre
	/@.lisp -m 1000KW -M mem.interpre -q -c macros1.lsp

fas.macros2 : lsp.macros2 lisp mem.interpre
	/@.lisp -m 1000KW -M mem.interpre -q -c macros2.lsp

fas.defs1 : lsp.defs1 lisp mem.interpre
	/@.lisp -m 1000KW -M mem.interpre -q -c defs1.lsp

fas.timezone : lsp.timezone lisp mem.interpre
	/@.lisp -m 1000KW -M mem.interpre -q -c timezone.lsp

fas.places : lsp.places lisp mem.interpre
	/@.lisp -m 1000KW -M mem.interpre -q -c places.lsp

fas.floatpri : lsp.floatpri lisp mem.interpre
	/@.lisp -m 1000KW -M mem.interpre -q -c floatpri.lsp

fas.type : lsp.type lisp mem.interpre
	/@.lisp -m 1000KW -M mem.interpre -q -c type.lsp

fas.defstruc : lsp.defstruc lisp mem.interpre
	/@.lisp -m 1000KW -M mem.interpre -q -c defstruc.lsp

fas.format : lsp.format lisp mem.interpre
	/@.lisp -m 1000KW -M mem.interpre -q -c format.lsp

fas.user1 : lsp.user1 lisp mem.interpre
	/@.lisp -m 1000KW -M mem.interpre -q -c user1.lsp

fas.user2 : lsp.user2 lisp mem.interpre
	/@.lisp -m 1000KW -M mem.interpre -q -c user2.lsp

fas.trace : lsp.trace lisp mem.interpre
	/@.lisp -m 1000KW -M mem.interpre -q -c trace.lsp

fas.macros3 : lsp.macros3 lisp mem.interpre
	/@.lisp -m 1000KW -M mem.interpre -q -c macros3.lsp

fas.config : lsp.config lisp mem.interpre
	/@.lisp -m 1000KW -M mem.interpre -q -c config.lsp

fas.compiler : lsp.compiler lisp mem.interpre
	/@.lisp -m 1000KW -M mem.interpre -q -c compiler.lsp

fas.disassem : lsp.disassem lisp mem.interpre
	/@.lisp -m 1000KW -M mem.interpre -q -c disassem.lsp

fas.defs2 : lsp.defs2 lisp mem.interpre
	/@.lisp -m 1000KW -M mem.interpre -q -c defs2.lsp

fas.loop : lsp.loop lisp mem.interpre
	/@.lisp -m 1000KW -M mem.interpre -q -c loop.lsp

fas.clos : lsp.clos lisp mem.interpre
	/@.lisp -m 1000KW -M mem.interpre -q -c clos.lsp

fas.conditio : lsp.conditio lisp mem.interpre
	/@.lisp -m 1000KW -M mem.interpre -q -c conditio.lsp

fas.defs3 : lsp.defs3 lisp mem.interpre
	/@.lisp -m 1000KW -M mem.interpre -q -c defs3.lsp

fas.gstream : lsp.gstream lisp mem.interpre
	/@.lisp -m 1000KW -M mem.interpre -q -c gstream.lsp

fas.foreign1 : lsp.foreign1 lisp mem.interpre
	/@.lisp -m 1000KW -M mem.interpre -q -c foreign1.lsp

fas.screen : lsp.screen lisp mem.interpre
	/@.lisp -m 1000KW -M mem.interpre -q -c screen.lsp

fas.rexx1 : lsp.rexx1 lisp mem.interpre
	/@.lisp -m 1000KW -M mem.interpre -q -c rexx1.lsp

fas.editor : lsp.editor lisp mem.interpre
	/@.lisp -m 1000KW -M mem.interpre -q -c editor.lsp

fas.spanish : lsp.spanish lisp mem.interpre
	/@.lisp -m 1000KW -M mem.interpre -q -c spanish.lsp

mem.halfcomp : lisp $(LSPFILES) fas.compiler
	-$(RM) mem.interpre
	/@.lisp -m 750KW -x "(load \"init.lsp\") (sys::%saveinitmem) (exit)"
	$(MV) mem.lispimag mem.interpre
	$(TOUCH) mem.interpre
	$(TOUCH) fas.compiler
	$(TOUCH) mem.halfcomp

mem.lispinit : lisp $(FASFILES)
	-$(RM) mem.lispinit
	/@.lisp -x "(load \"init.fas\") (sys::%saveinitmem) (exit)"
	$(MV) mem.lispimag mem.lispinit


# Perform self-tests.
check : test
	$(TOUCH) check

# Test: recompile $(LSPFILES) and compare their contents.
test : mem.lispinit stage $(TESTLSPFILES) $(TESTFASFILES)
	echo "Compare the .fas files by hand."

stage :
	-mkdir stage

stage.lsp.init : lsp.init
	$(LN) lsp.init stage

stage.lsp.defseq : lsp.defseq
	$(LN) lsp.defseq stage

stage.lsp.backquot : lsp.backquot
	$(LN) lsp.backquot stage

stage.lsp.defmacro : lsp.defmacro
	$(LN) lsp.defmacro stage

stage.lsp.macros1 : lsp.macros1
	$(LN) lsp.macros1 stage

stage.lsp.macros2 : lsp.macros2
	$(LN) lsp.macros2 stage

stage.lsp.defs1 : lsp.defs1
	$(LN) lsp.defs1 stage

stage.lsp.timezone : lsp.timezone
	$(LN) lsp.timezone stage

stage.lsp.places : lsp.places
	$(LN) lsp.places stage

stage.lsp.floatpri : lsp.floatpri
	$(LN) lsp.floatpri stage

stage.lsp.type : lsp.type
	$(LN) lsp.type stage

stage.lsp.defstruc : lsp.defstruc
	$(LN) lsp.defstruc stage

stage.lsp.format : lsp.format
	$(LN) lsp.format stage

stage.lsp.user1 : lsp.user1
	$(LN) lsp.user1 stage

stage.lsp.user2 : lsp.user2
	$(LN) lsp.user2 stage

stage.lsp.trace : lsp.trace
	$(LN) lsp.trace stage

stage.lsp.macros3 : lsp.macros3
	$(LN) lsp.macros3 stage

stage.lsp.config : lsp.config
	$(LN) lsp.config stage

stage.lsp.compiler : lsp.compiler
	$(LN) lsp.compiler stage

stage.lsp.disassem : lsp.disassem
	$(LN) lsp.disassem stage

stage.lsp.defs2 : lsp.defs2
	$(LN) lsp.defs2 stage

stage.lsp.loop : lsp.loop
	$(LN) lsp.loop stage

stage.lsp.clos : lsp.clos
	$(LN) lsp.clos stage

stage.lsp.conditio : lsp.conditio
	$(LN) lsp.conditio stage

stage.lsp.defs3 : lsp.defs3
	$(LN) lsp.defs3 stage

stage.lsp.gstream : lsp.gstream
	$(LN) lsp.gstream stage

stage.lsp.foreign1 : lsp.foreign1
	$(LN) lsp.foreign1 stage

stage.lsp.screen : lsp.screen
	$(LN) lsp.screen stage

stage.lsp.rexx1 : lsp.rexx1
	$(LN) lsp.rexx1 stage

stage.lsp.editor : lsp.editor
	$(LN) lsp.editor stage

stage.lsp.spanish : lsp.spanish
	$(LN) lsp.spanish stage

stage.fas.init : stage.lsp.init lisp mem.lispinit
	/@.lisp -M mem.lispinit -q -c stage.init.lsp

stage.fas.defseq : stage.lsp.defseq lisp mem.lispinit
	/@.lisp -M mem.lispinit -q -c stage.defseq.lsp

stage.fas.backquot : stage.lsp.backquot lisp mem.lispinit
	/@.lisp -M mem.lispinit -q -c stage.backquot.lsp

stage.fas.defmacro : stage.lsp.defmacro lisp mem.lispinit
	/@.lisp -M mem.lispinit -q -c stage.defmacro.lsp

stage.fas.macros1 : stage.lsp.macros1 lisp mem.lispinit
	/@.lisp -M mem.lispinit -q -c stage.macros1.lsp

stage.fas.macros2 : stage.lsp.macros2 lisp mem.lispinit
	/@.lisp -M mem.lispinit -q -c stage.macros2.lsp

stage.fas.defs1 : stage.lsp.defs1 lisp mem.lispinit
	/@.lisp -M mem.lispinit -q -c stage.defs1.lsp

stage.fas.timezone : stage.lsp.timezone lisp mem.lispinit
	/@.lisp -M mem.lispinit -q -c stage.timezone.lsp

stage.fas.places : stage.lsp.places lisp mem.lispinit
	/@.lisp -M mem.lispinit -q -c stage.places.lsp

stage.fas.floatpri : stage.lsp.floatpri lisp mem.lispinit
	/@.lisp -M mem.lispinit -q -c stage.floatpri.lsp

stage.fas.type : stage.lsp.type lisp mem.lispinit
	/@.lisp -M mem.lispinit -q -c stage.type.lsp

stage.fas.defstruc : stage.lsp.defstruc lisp mem.lispinit
	/@.lisp -M mem.lispinit -q -c stage.defstruc.lsp

stage.fas.format : stage.lsp.format lisp mem.lispinit
	/@.lisp -M mem.lispinit -q -c stage.format.lsp

stage.fas.user1 : stage.lsp.user1 lisp mem.lispinit
	/@.lisp -M mem.lispinit -q -c stage.user1.lsp

stage.fas.user2 : stage.lsp.user2 lisp mem.lispinit
	/@.lisp -M mem.lispinit -q -c stage.user2.lsp

stage.fas.trace : stage.lsp.trace lisp mem.lispinit
	/@.lisp -M mem.lispinit -q -c stage.trace.lsp

stage.fas.macros3 : stage.lsp.macros3 lisp mem.lispinit
	/@.lisp -M mem.lispinit -q -c stage.macros3.lsp

stage.fas.config : stage.lsp.config lisp mem.lispinit
	/@.lisp -M mem.lispinit -q -c stage.config.lsp

stage.fas.compiler : stage.lsp.compiler lisp mem.lispinit
	/@.lisp -M mem.lispinit -q -c stage.compiler.lsp

stage.fas.disassem : stage.lsp.disassem lisp mem.lispinit
	/@.lisp -M mem.lispinit -q -c stage.disassem.lsp

stage.fas.defs2 : stage.lsp.defs2 lisp mem.lispinit
	/@.lisp -M mem.lispinit -q -c stage.defs2.lsp

stage.fas.loop : stage.lsp.loop lisp mem.lispinit
	/@.lisp -M mem.lispinit -q -c stage.loop.lsp

stage.fas.clos : stage.lsp.clos lisp mem.lispinit
	/@.lisp -M mem.lispinit -q -c stage.clos.lsp

stage.fas.conditio : stage.lsp.conditio lisp mem.lispinit
	/@.lisp -M mem.lispinit -q -c stage.conditio.lsp

stage.fas.defs3 : stage.lsp.defs3 lisp mem.lispinit
	/@.lisp -M mem.lispinit -q -c stage.defs3.lsp

stage.fas.gstream : stage.lsp.gstream lisp mem.lispinit
	/@.lisp -M mem.lispinit -q -c stage.gstream.lsp

stage.fas.foreign1 : stage.lsp.foreign1 lisp mem.lispinit
	/@.lisp -M mem.lispinit -q -c stage.foreign1.lsp

stage.fas.screen : stage.lsp.screen lisp mem.lispinit
	/@.lisp -M mem.lispinit -q -c stage.screen.lsp

stage.fas.rexx1 : stage.lsp.rexx1 lisp mem.lispinit
	/@.lisp -M mem.lispinit -q -c stage.rexx1.lsp

stage.fas.editor : stage.lsp.editor lisp mem.lispinit
	/@.lisp -M mem.lispinit -q -c stage.editor.lsp

stage.fas.spanish : stage.lsp.spanish lisp mem.lispinit
	/@.lisp -M mem.lispinit -q -c stage.spanish.lsp

mem.lispinit2 : lisp $(TESTFASFILES)
	/@.lisp -x "(cd \"stage.\") (load \"init.fas\") (cd \"^.\") (sys::%saveinitmem) (exit)"
	-$(RM) mem.lispinit2
	$(MV) mem.lispimag mem.lispinit2


READMES = ANNOUNCE COPYRIGHT GNU-GPL SUMMARY NEWS README README_de README_en README_es
MANUALS = 1.clisp html.clisp txt.impnotes $(TXTFILES)

manual : $(READMES) $(MANUALS)
	$(TOUCH) manual

manualx : manual man.clisp
	$(TOUCH) manualx

ANNOUNCE : ^.ANNOUNCE
	-$(LN) ^.ANNOUNCE ANNOUNCE

COPYRIGHT : ^.COPYRIGHT
	-$(LN) ^.COPYRIGHT COPYRIGHT

GNU-GPL : ^.GNU-GPL
	-$(LN) ^.GNU-GPL GNU-GPL

SUMMARY : ^.SUMMARY
	-$(LN) ^.SUMMARY SUMMARY

README : _README c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn _README_de _README_en txt2c 
	$(TXT2C) < _README > text.c
	$(CC) $(CFLAGS) $(CLFLAGS) c.text -o text
	/@.text > README
	$(RM) c.text
	$(RM) text

README_de : _README_de c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn txt2c 
	$(TXT2C) < _README_de > text.c
	$(CC) $(CFLAGS) $(CLFLAGS) c.text -o text
	/@.text > README_de
	$(RM) c.text
	$(RM) text

README_en : _README_en c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn txt2c 
	$(TXT2C) < _README_en > text.c
	$(CC) $(CFLAGS) $(CLFLAGS) c.text -o text
	/@.text > README_en
	$(RM) c.text
	$(RM) text

README_es : _README_es c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn txt2c 
	$(TXT2C) < _README_es > text.c
	$(CC) $(CFLAGS) $(CLFLAGS) c.text -o text
	/@.text > README_es
	$(RM) c.text
	$(RM) text

1.clisp : 1._clisp c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn txt2c 
	$(TXT2C) < 1._clisp > text.c
	$(CC) $(CFLAGS) $(CLFLAGS) c.text -o text
	/@.text > TMPPIPE1
	$(GREP) -v -f ^.acorn.in.grep < TMPPIPE1 > 1.clisp
	$(RM) TMPPIPE1
	$(RM) c.text
	$(RM) text

html.clisp : html._clisp c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn txt2c 
	$(TXT2C) < html._clisp > text.c
	$(CC) $(CFLAGS) $(CLFLAGS) c.text -o text
	/@.text > html.clisp
	$(RM) c.text
	$(RM) text

txt.impnotes : txt._impnotes c.lispbibl c.fsubr c.subr c.pseudofun c.constsym c.constobj c.acorn txt2c 
	$(TXT2C) < txt._impnotes > text.c
	$(CC) $(CFLAGS) $(CLFLAGS) c.text -o text
	/@.text > txt.impnotes
	$(RM) c.text
	$(RM) text

man.clisp : 1.clisp
	$(ROFF_MAN) 1.clisp > man.clisp

dvi.clisp : 1.clisp
	$(ROFF_DVI) 1.clisp > dvi.clisp

txt.LISP-tutorial : ^.doc.txt.LISP-tutorial
	-$(LN) ^.doc.txt.LISP-tutorial txt.LISP-tutorial

txt.CLOS-guide : ^.doc.txt.CLOS-guide
	-$(LN) ^.doc.txt.CLOS-guide txt.CLOS-guide

txt.cltl2 : ^.doc.txt.cltl2
	-$(LN) ^.doc.txt.cltl2 txt.cltl2

txt.editors : ^.doc.txt.editors
	-$(LN) ^.doc.txt.editors txt.editors


distrib : force all manualx
	-cdir ^.!Clisp
	$(CP) lisp ^.!Clisp.lisp
	squeeze ^.!Clisp.lisp
	-cdir ^.!Clisp.mem
	$(CP) mem.lispinit ^.!Clisp.mem.lispinit
	$(CP) ANNOUNCE ^.!Clisp.ANNOUNCE
	$(CP) COPYRIGHT ^.!Clisp.COPYRIGHT
	$(CP) GNU-GPL ^.!Clisp.GNU-GPL
	$(CP) SUMMARY ^.!Clisp.SUMMARY
	$(CP) NEWS ^.!Clisp.NEWS
	$(CP) README ^.!Clisp.README
	$(CP) README_de ^.!Clisp.README_de
	$(CP) README_es ^.!Clisp.README_es
	-cdir ^.!Clisp.1
	$(CP) 1.clisp ^.!Clisp.1.clisp
	-cdir ^.!Clisp.man
	$(CP) man.clisp ^.!Clisp.man.clisp
	-cdir ^.!Clisp.html
	$(CP) html.clisp ^.!Clisp.html.clisp
	settype ^.!Clisp.html.clisp FAF
	-cdir ^.!Clisp.txt
	$(CP) txt.impnotes ^.!Clisp.txt.impnotes
	$(CP) txt.LISP-tutor ^.!Clisp.txt.LISP-tutor
	$(CP) txt.CLOS-guide ^.!Clisp.txt.CLOS-guide
	$(CP) txt.cltl2 ^.!Clisp.txt.cltl2
	$(CP) txt.editors ^.!Clisp.txt.editors
	-cdir ^.!Clisp.lsp
	$(CP) lsp.config ^.!Clisp.lsp.config
	$(CP) lsp.timezone ^.!Clisp.lsp.timezone
	$(CP) ^.acorn.!Run ^.!Clisp.!Run
	settype ^.!Clisp.!Run Obey
	$(CP) ^.acorn.!Sprites ^.!Clisp.!Sprites
	settype ^.!Clisp.!Sprites Sprite

# clean0 is harmless: removes only superfluous things: temporary files.
clean0 : force
	-$(RM) core c.ansidecl c.ccmp2c genclisph wgenclisph linkkit c.text text

# clean1 removes everything that becomes obsolete once lisp is recompiled
# without changing the bytecode format and the tables in
# constobj.d, constpack.d, constsym.d, subr.d, fsubr.d, pseudofun.d.
clean1 : clean0
	-$(RM) h.lispbibl h.wlispbibl h.clisp *.i *.s *.o *.a lisp wlisp clisp-link makevars stage.* suite.* wstage.* wsuite.*
	-rmdir stage
	-rmdir suite
	-rmdir wstage
	-rmdir wsuite
	-$(RM) README README_de README_en README_es 1.clisp man.clisp html.clisp txt.impnotes c.clisp distmakefile $(TXTFILES) clreadline.3 man.clreadline html.clreadline dvi.clreadline dvi.readline

# clean2 removes everything that becomes obsolete once lisp is recompiled
# without changing the bytecode format.
clean2 : clean1
	-$(RM) mem.interpre mem.halfcomp mem.lispinit mem.lispinit2 mem.wlispinit mem.wlispinit2

# clean3 removes everything that becomes obsolete once lisp is recompiled.
# It leaves everything generated by "make allc".
clean3 : clean2
	-$(RM) $(FASFILES) *.lib

# clean4 removes everything that becomes obsolete
# when switching to a new version of the C compiler.
# It leaves everything generated by "make init".
clean4 : clean3
	-$(RM) $(CFILES)

# clean5 even undoes "make init".
clean5 : clean4
	-$(RM) lsp.config
	-$(RM) comment5 ansidecl ccpaux deelif deerror dedefined traddecl deema mergestrings txt2c

# clean6 lets us go back to "makemake > Makefile".
clean6 : clean5
	-$(RM) Makefile

# clean7 lets us go back to the main "configure".
clean7 : clean6
	-$(RM) config.status config.log config.cache h.intparam h.unixconf makemake

# clean8 moreover cleans up the SRCDIR.
clean8 : clean7

# The normal "start over" command:
mostlyclean : clean4

# Clear all files that are built by "make ...":
clean : clean5

# Make "clear for distribution":
distclean : clean7

# Remove everything that can be generated otherwise:
maintainer-clean : clean8


.SUFFIXES:
	$(TOUCH) .SUFFIXES

force:
	$(TOUCH) force

