""" Locale dependant formatting and parsing.

    XXX This module still has prototype status and is undocumented.

    (c) 1998, Copyright Marc-Andre Lemburg; All Rights Reserved.
    See the documentation for further information on copyrights,
    or contact the author (mal@lemburg.com).
"""

class _TimeLocale:

    """ Base class for locale dependant formatting and parsing.
    """
    # Examples:
    Weekday = ('Monday','Tuesday','Wednesday','Thrusday','Friday','Saturday',
	       'Sunday')
    Month = (None,
	     'January','Febuary','March','April','May','June',
	     'July','August','September','October','November','December')
    
    def str(self,d):
	
	"""str(datetime)
	Return the given DateTime instance formatted according to the
	locale's convention. Timezone information is not presented."""
	
	return '%s %02i %s %04i %02i:%02i:%02i' % (
	    self.Weekday[d.day_of_week],
	    d.day,self.Month[d.month],d.year,
	    d.hour,d.minute,d.second)

    # Alias
    ctime = str

# Singletons that implement the specific methods.

class English(_TimeLocale):
    Weekday = ('Monday','Tuesday','Wednesday','Thrusday','Friday','Saturday',
	       'Sunday')
    Month = (None,
	     'January','Febuary','March','April','May','June',
	     'July','August','September','October','November','December')

English = English()

class German(_TimeLocale):
    Weekday = ('Montag','Dienstag','Mittwoch','Donnerstag','Freitag','Samstag',
	       'Sonntag')
    Month = (None,
	     'Januar','Febuar','Mrz','April','Mai','Juni',
	     'Juli','August','September','Oktober','November','Dezember')

German = German()

class French(_TimeLocale):
    Weekday = ('lundi','mardi','mercredi','jeudi','vendredi','samedi',
	       'dimanche')
    Month = (None,
	     'janvier','fvrier','mars','avril','mai','juin',
	     'juillet','aot','septembre','octobre','novembre','dcembre')

French = French()

class Spanish(_TimeLocale):
    Weekday = ('lunes' 'martes','rcoles','jueves','viernes','bado','domingo')
    Month = (None,
	     'enero','febrero','marzo','abril','mayo','junio',
	     'julio','agosto','septiembre','octubre','noviembre','diciembre')

Spanish = Spanish()

class Portuguese(_TimeLocale):
    Weekday = ('segunda','ter','quarta','quinta','sexta','bado','domingo')
    Month = (None,
	     'janeiro','fevereiro','mar','abril','maio','junho',
	     'julho','agosto','septembro','outubro','novembro','dezembro')

Portuguese = Portuguese()

###

def _test():

    import DateTime
    d = DateTime.now()
    for lang in (English,German,French,Spanish,Portuguese):
        print lang.__class__.__name__,':',lang.ctime(d)

if __name__ == '__main__':
    _test()
