/*
	Audio File Library

	Copyright 1998, Michael Pruett <michael@68k.org>

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License as
	published by the Free Software Foundation; either version 2 of
	the License, or (at your option) any later version.

	This program is distributed in the hope that it will be
	useful, but WITHOUT ANY WARRANTY; without even the implied
	warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
	PURPOSE.  See the GNU General Public License for more details.

	You should have received a copy of the GNU General Public
	License along with this program; if not, write to the Free
	Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
	MA 02111-1307, USA.
*/

/*
	transparency.c

	This program does a slight sanity check on file writing
	operations.
*/

#include <stdio.h>

#ifdef USE_SGI_HEADERS
#include <dmedia/audiofile.h>
#else
#include <audiofile.h>
#endif

main (int ac, char **av)
{
	AFfilehandle	outfile;
	AFfilesetup		outfilesetup;
	short			buffer[] = {0x1122, 0x3344, 0x5566, 0x7788,
								0x99aa, 0xbbcc, 0xddee, 0xff00};

	outfilesetup = afNewFileSetup();
	afInitFileFormat(outfilesetup, AF_FILE_WAVE);

	outfile = afOpenFile(av[1], "w", outfilesetup);
	afWriteFrames(outfile, AF_DEFAULT_TRACK, buffer, 2);
	afWriteFrames(outfile, AF_DEFAULT_TRACK, buffer + 4, 2);
	afCloseFile(outfile);

	outfile = afOpenFile(av[2], "w", outfilesetup);
	afWriteFrames(outfile, AF_DEFAULT_TRACK, buffer, 4);
	afCloseFile(outfile);

	afFreeFileSetup(outfilesetup);
}
