/*
 * bltWinPrnt.c --
 *
 *	This module implements WIN32 printer access from Tk widgets.
 *
 * Copyright 1998 by Bell Labs Innovations for Lucent Technologies.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that the
 * copyright notice and warranty disclaimer appear in supporting documentation,
 * and that the names of Lucent Technologies any of their entities not be used
 * in advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 *
 * Lucent Technologies disclaims all warranties with regard to this software,
 * including all implied warranties of merchantability and fitness.  In no event
 * shall Lucent Technologies be liable for any special, indirect or
 * consequential damages or any damages whatsoever resulting from loss of use,
 * data or profits, whether in an action of contract, negligence or other
 * tortuous action, arising out of or in connection with the use or performance
 * of this software.
 *
 */

#include <bltInt.h>
#include <X11/Xutil.h>
#include <X11/Xlib.h>

#include <windowsx.h>
#include <commdlg.h>

extern HINSTANCE TclWinGetTclInstance(void);

typedef struct {
    int type;
    HDC hdc;
    DOCINFO docInfo;
} PrintDrawable;

int
Blt_GetPrinter(Drawable *drawablePtr)
{
    static PrintDrawable drawable;
    static PRINTDLG printInfo;

    if ((printInfo.hDevNames == NULL) && (printInfo.hDevMode == NULL)) {

	memset((char *)&printInfo, 0, sizeof(PRINTDLG));
	printInfo.lStructSize = sizeof(PRINTDLG);
	printInfo.Flags = PD_RETURNDC | PD_PRINTSETUP;
	printInfo.nMinPage = 1;
	printInfo.nMaxPage = 1;
	printInfo.nCopies = 1;
    }
    if (!PrintDlg(&printInfo)) {
	return CommDlgExtendedError();
    }
    drawable.type = TWD_WINDC;
    drawable.hdc = printInfo.hDC;
    memset((char *)&drawable.docInfo, 0, sizeof(DOCINFO));
    drawable.docInfo.cbSize = sizeof(DOCINFO);
    drawable.docInfo.lpszDocName = NULL;
    drawable.docInfo.lpszOutput = NULL;
    StartDoc(printInfo.hDC, &drawable.docInfo);
    *drawablePtr = (Drawable)&drawable;
    return 0;
}

int
Blt_FreePrinter(Drawable drawable)
{
    int result;

    PrintDrawable *printPtr = (PrintDrawable *)drawable;
    result = EndPage(printPtr->hdc);
    EndDoc(printPtr->hdc);
    if (!result) {
	return TCL_ERROR;
    }
    return TCL_OK;
}
