/*	demo.C

	The Forms demo program, rewritten in fltk.
	The original code compiled fine, but this version does not use
	<forms.h>

*/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#ifdef WIN32
# include <direct.h>
//# define chdir _chdir
#else
# include <unistd.h>
#endif
#include <FL/Fl.H>
#include <FL/Fl_Window.H>
#include <FL/Fl_Box.H>
#include <FL/Fl_Button.H>
#include <FL/filename.H>

/* The form description */

void doexit(Fl_Widget *, void *);
void doback(Fl_Widget *, void *);
void dobut(Fl_Widget *, long);

Fl_Window *form;
Fl_Button *but[9];

void create_the_forms() {
  Fl_Widget *obj;
  form = new Fl_Window(370, 450);
  obj = new Fl_Box(FL_FRAME_BOX,20,390,330,40,"Fltk Demonstration");
  obj->color(FL_GRAY-4);
  obj->labelsize(24);
  obj->labelfont(FL_BOLD);
  obj->labeltype(FL_ENGRAVED_LABEL);
  obj = new Fl_Box(FL_FRAME_BOX,20,50,330,330,0);
  obj->color(FL_GRAY-8);
  obj = new Fl_Button(130,10,110,30,"Exit");
  obj->callback(doexit);
  obj = new Fl_Button(20,50,330,380); obj->type(FL_HIDDEN_BUTTON);
  obj->callback(doback);
  obj = but[0] = new Fl_Button(40,270,90,90);
  obj->callback(dobut,0);
  obj = but[1] = new Fl_Button(140,270,90,90);
  obj->callback(dobut,1);
  obj = but[2] = new Fl_Button(240,270,90,90);
  obj->callback(dobut,2);
  obj = but[5] = new Fl_Button(240,170,90,90);
  obj->callback(dobut,5);
  obj = but[4] = new Fl_Button(140,170,90,90);
  obj->callback(dobut,4);
  obj = but[3] = new Fl_Button(40,170,90,90);
  obj->callback(dobut,3);
  obj = but[6] = new Fl_Button(40,70,90,90);
  obj->callback(dobut,6);
  obj = but[7] = new Fl_Button(140,70,90,90);
  obj->callback(dobut,7);
  obj = but[8] = new Fl_Button(240,70,90,90);
  obj->callback(dobut,8);
  form->end();
  form->flip();
}

/* Maintaining and building up the menus. */

typedef struct {
  char name[64];
  int numb;
  char iname[9][64];
  char icommand[9][64];
} MENU;

#define MAXMENU	32

MENU menus[MAXMENU];
int mennumb = 0;

int find_menu(char nnn[])
/* Returns the number of a given menu name. */
{
  int i;
  for (i=0; i<mennumb; i++)
    if (strcmp(menus[i].name,nnn) == 0) return i;
  return -1;
}

void create_menu(char nnn[])
/* Creates a new menu with name nnn */
{
  if (mennumb == MAXMENU -1) return;
  strcpy(menus[mennumb].name,nnn);
  menus[mennumb].numb = 0;
  mennumb++;
}

void addto_menu(char men[], char item[], char comm[])
/* Adds an item to a menu */
{
  int n = find_menu(men);
  if (n<0) { create_menu(men); n = find_menu(men); }
  if (menus[n].numb == 9) return;
  strcpy(menus[n].iname[menus[n].numb],item);
  strcpy(menus[n].icommand[menus[n].numb],comm);
  menus[n].numb++;
}

/* Button to Item conversion and back. */

int b2n[][9] = { 
	{ -1, -1, -1, -1,  0, -1, -1, -1, -1},
	{ -1, -1, -1,  0, -1,  1, -1, -1, -1},
	{  0, -1, -1, -1,  1, -1, -1, -1,  2},
	{  0, -1,  1, -1, -1, -1,  2, -1,  3},
	{  0, -1,  1, -1,  2, -1,  3, -1,  4},
	{  0, -1,  1,  2, -1,  3,  4, -1,  5},
	{  0, -1,  1,  2,  3,  4,  5, -1,  6},
	{  0,  1,  2,  3, -1,  4,  5,  6,  7},
	{  0,  1,  2,  3,  4,  5,  6,  7,  8}
  };
int n2b[][9] = { 
	{  4, -1, -1, -1, -1, -1, -1, -1, -1},
	{  3,  5, -1, -1, -1, -1, -1, -1, -1},
	{  0,  4,  8, -1, -1, -1, -1, -1, -1},
	{  0,  2,  6,  8, -1, -1, -1, -1, -1},
	{  0,  2,  4,  6,  8, -1, -1, -1, -1},
	{  0,  2,  3,  5,  6,  8, -1, -1, -1},
	{  0,  2,  3,  4,  5,  6,  8, -1, -1},
	{  0,  1,  2,  3,  5,  6,  7,  8, -1},
	{  0,  1,  2,  3,  4,  5,  6,  7,  8}
  };

int but2numb(int bnumb, int maxnumb)
/* Transforms a button number to an item number when there are
   maxnumb items in total. -1 if the button should not exist. */
 { return b2n[maxnumb][bnumb]; }

int numb2but(int inumb, int maxnumb)
/* Transforms an item number to a button number when there are
   maxnumb items in total. -1 if the item should not exist. */
 { return n2b[maxnumb][inumb]; }

/* Pushing and Popping menus */

char stack[64][32];
char stsize = 0;

void push_menu(char nnn[])
/* Pushes a menu to be visible */
{
  int n,i,bn;
  int men = find_menu(nnn);
  if (men < 0) return;
  n = menus[men].numb;
  for (i=0; i<9; i++) but[i]->hide();
  for (i=0; i<n; i++)
  {
    bn = numb2but(i,n-1);
    but[bn]->show();
    but[bn]->label(menus[men].iname[i]);
//     if (menus[men].icommand[i][0] == '@')
//       but[bn]->color(FL_GRAY-8);
//     else
//       but[bn]->color(FL_GRAY);
  }
  strcpy(stack[stsize],nnn);
  stsize++;
}

void pop_menu()
/* Pops a menu */
{
  if (stsize<=1) return;
  stsize -= 2;
  push_menu(stack[stsize]);
}

/* The callback Routines */

void dobut(Fl_Widget *, long arg)
/* handles a button push */
{
  int men = find_menu(stack[stsize-1]);
  int n = menus[men].numb;
  int bn = but2numb( (int) arg, n-1);
  if (menus[men].icommand[bn][0] == '@')
    push_menu(menus[men].icommand[bn]);
  else
    system(menus[men].icommand[bn]);
}

void doback(Fl_Widget *, void *) {pop_menu();}

void doexit(Fl_Widget *, void *) {exit(0);}

int load_the_menu(const char fname[])
/* Loads the menu file. Returns whether successful. */
{
  FILE *fin;
  char line[256], mname[64],iname[64],cname[64];
  int i,j;
  fin = fopen(fname,"r");
  if (fin == NULL)
  {
//    fl_show_message("ERROR","","Cannot read the menu description file.");
    return 0;
  }
  for (;;) {
    if (fgets(line,256,fin) == NULL) break;
    j = 0; i = 0;
    while (line[i] == ' ' || line[i] == '\t') i++;
    if (line[i] == '\n') continue;
    if (line[i] == '#') continue;
    while (line[i] != ':' && line[i] != '\n') mname[j++] = line[i++];
    mname[j] = '\0';
    if (line[i] == ':') i++;
    j = 0; 
    while (line[i] != ':' && line[i] != '\n')
    {
      if (line[i] == '\\' && line[i+1] == 'n')
        { iname[j++] = '\n'; i += 2; }
      else
        iname[j++] = line[i++];
    }
    iname[j] = '\0';
    if (line[i] == ':') i++;
    j = 0;
    while (line[i] != ':' && line[i] != '\n') cname[j++] = line[i++];
    cname[j] = '\0';
    addto_menu(mname,iname,cname);
  }
  fclose(fin);
  return 1;
}

int main(int argc, char **argv) {
  create_the_forms();
  char buf[256];
  strcpy(buf, argv[0]);
  strcat(buf, ".menu");
  const char *fname = buf;
  int i = 0;
  if (!Fl::args(argc,argv,i) || i < argc-1)
    Fl::fatal("Usage: %s <switches> <menufile>\n%s",Fl::help);
  if (i < argc) fname = argv[i];
  if (!load_the_menu(fname)) Fl::fatal("Can't open %s",fname);
  strcpy(buf,fname);
  const char *c = filename_name(buf);
  if (c > buf) {buf[c-buf] = 0; chdir(buf);}
  push_menu("@main");
  form->show(argc,argv);
  Fl::run();
  return 0;
}
