/* $Id: hline.c,v 1.7 1998/09/20 21:22:50 marcus Exp $
***************************************************************************

   Graphics library for GGI. Horizontal lines.

   Copyright (C) 1995 Andreas Beck [becka@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include <string.h>

#include <ggi/internal/ggi-dl.h>

/**********************************/
/* draw/get/put a horizontal line */
/**********************************/

int GGIdrawhline(ggi_visual *vis,int x,int y,int w)
{
	/* Clipping */
	if (y<(LIBGGI_GC(vis)->cliptl.y) || y>=(LIBGGI_GC(vis)->clipbr.y)) return 0;
	if (x< (LIBGGI_GC(vis)->cliptl.x)) {
		int diff=(LIBGGI_GC(vis)->cliptl.x)-x;
		x+=diff;
		w-=diff;
	}
	if (x+w>(LIBGGI_GC(vis)->clipbr.x)) {
		w=(LIBGGI_GC(vis)->clipbr.x)-x;
	}
	if (w>0) {
		int i;
		uint32 *fb=(uint32 *)LIBGGI_CURWRITE(vis);

		fb = (uint32 *) ((uint8 *)fb
				+ y*LIBGGI_FB_W_STRIDE(vis)+x*sizeof(uint32));
		for (i=0;i<w;i++) 
			*(fb++)=LIBGGI_GC_FGCOLOR(vis);
	}
	return 0;
}

int GGIdrawhline_nc(ggi_visual *vis,int x,int y,int w)
{
	int i;
	uint32 *fb=(uint32 *)LIBGGI_CURWRITE(vis);

	fb = (uint32 *) ((uint8 *)fb
			 + y*LIBGGI_FB_W_STRIDE(vis)+x*sizeof(uint32));
	for (i=0;i<w;i++) 
		*(fb++)=LIBGGI_GC_FGCOLOR(vis);

	return 0;
}

int GGIputhline(ggi_visual *vis,int x,int y,int w,void *buffer)
{ 
	uint32 *mem;

	/* Clipping */
	if (y<(LIBGGI_GC(vis)->cliptl.y) || y>=(LIBGGI_GC(vis)->clipbr.y)) return 0;
	if (x< (LIBGGI_GC(vis)->cliptl.x)) {
		int diff=(LIBGGI_GC(vis)->cliptl.x)-x;
		x+=diff;
		w-=diff;
		buffer=((uint32 *)buffer)+diff;
	}
	if (x+w>(LIBGGI_GC(vis)->clipbr.x)) {
		w=(LIBGGI_GC(vis)->clipbr.x)-x;
	}
	if (w>0) {
		mem =(uint32 *)LIBGGI_CURWRITE(vis);
		mem = (uint32 *) ((uint8 *)mem
				 + y*LIBGGI_FB_W_STRIDE(vis)+x*sizeof(uint32));
		memcpy(mem,buffer,w*sizeof(uint32));
	}
	return 0;
}

int GGIgethline(ggi_visual *vis,int x,int y,int w,void *buffer)
{ 
	uint32 *mem;

	mem =(uint32 *)LIBGGI_CURREAD(vis);
	mem = (uint32 *) ((uint8 *)mem
			  + y*LIBGGI_FB_R_STRIDE(vis)+x*sizeof(uint32));

	memcpy(buffer,mem,w*sizeof(uint32));

	return 0;
}

