/* $Id: pixel.c,v 1.9 1998/09/26 03:20:53 marcus Exp $
***************************************************************************

   Graphics library for GGI. Pixels.

   Copyright (C) 1997 Jason McMullan   [jmcc@ggi-project.org]
   Copyright (C) 1995 Andreas Beck     [becka@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include "lin8lib.h"

/*******************************/
/* draw/get/put a single pixel */
/*******************************/

int GGI_lin8_drawpixel(ggi_visual *vis,int x,int y)
{
	/* This already clips right. */
	CHECKXY(vis,x,y);
 
	*((uint8 *)LIBGGI_CURWRITE(vis)+y*LIBGGI_FB_W_STRIDE(vis)+x)=LIBGGI_GC_FGCOLOR(vis);

	return 0;
}

int GGI_lin8_drawpixel_nc(ggi_visual *vis,int x,int y)
{
	*((uint8 *)LIBGGI_CURWRITE(vis)+y*LIBGGI_FB_W_STRIDE(vis)+x)=LIBGGI_GC_FGCOLOR(vis);

	return 0;
}

int GGI_lin8_putpixel_nc(ggi_visual *vis,int x,int y,ggi_pixel col)
{ 
	*((uint8 *)LIBGGI_CURWRITE(vis)+y*LIBGGI_FB_W_STRIDE(vis)+x)=(col&0xff);

	return 0;
}

int GGI_lin8_putpixel(ggi_visual *vis,int x,int y,ggi_pixel col)
{ 
	CHECKXY(vis,x,y);

	*((uint8 *)LIBGGI_CURWRITE(vis)+y*LIBGGI_FB_W_STRIDE(vis)+x)=(col&0xff);

	return 0;
}

int GGI_lin8_getpixel(ggi_visual *vis,int x,int y,ggi_pixel *pixel)
{ 
	*pixel=*((uint8 *)LIBGGI_CURREAD(vis)+y*LIBGGI_FB_R_STRIDE(vis)+x);

	return 0;
}

