/* $Id: color.inc,v 1.15 1998/10/13 07:54:11 marcus Exp $
***************************************************************************

   Color functions for the various X targets.

   Copyright (C) 1997 Andreas Beck      [becka@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include <ggi/internal/ggi-dl.h>


#ifndef GGI_DGA_TARGET

/* Minimum number of colors needed before we use the `smart allocation'
 * method for choosing where to put colors with GGI_PALETTE_DONTCARE.
 */
#define COLOR_THRESHOLD(num,max)  ((num)*4 >= (max)*3)


#if 0  /* not yet implemented */
static int _ggi_smart_allocate(ggi_visual *vis, int len, ggi_color *cols)
{
	struct Xhooks *xhook=LIBGGI_PRIVATE(vis);
	
	/* ... */
}
#endif

int GGI_X_setpalvec(ggi_visual *vis, int start, int len, ggi_color *colormap)
{
	struct Xhooks *xhook=LIBGGI_PRIVATE(vis);
	
	DPRINT_COLOR("X setpalette.\n");

	if (colormap==NULL)
		return -1;

	if (start == GGI_PALETTE_DONTCARE) {

		if (len > xhook->nocols) {
			return -1;
		}

#if 0  /* not yet implemented */
		if (COLOR_THRESHOLD(len, xhook->nocols)) {
			return _ggi_smart_allocate(vis, len, colormap);
		}
#endif

		start = xhook->nocols - len;
	}
		
	if (start+len > xhook->nocols || start < 0)
		return -1;

	memcpy(vis->palette+start, colormap, len*sizeof(ggi_color));

	if ( start     < xhook->cmap_first ) xhook->cmap_first = start;
	if ( start+len > xhook->cmap_last  ) xhook->cmap_last  = start+len;

	return 0;
}

#else /* GGI_DGA_TARGET */

int GGI_X_setpalvec(ggi_visual *vis, int start, int len,ggi_color *colormap) 
{
	int i;
	XColor xcol;
	struct Xhooks *xhook=LIBGGI_PRIVATE(vis);

	if (start == GGI_PALETTE_DONTCARE)
		start = 0;

	if (colormap==NULL || start+len >XLIB_PRIV(vis)->nocols)
		return -1;

	memcpy(vis->palette+start,colormap,len*sizeof(ggi_color));

	_ggiLock(xhook->XLibLock);

	for(i = start; i<start+len; i++) {
		xcol.red  =vis->palette[i].r;
		xcol.green=vis->palette[i].g;
		xcol.blue =vis->palette[i].b;
		xcol.pixel=i;
		xcol.flags= DoRed | DoGreen | DoBlue ;
		XStoreColor(xhook->display, xhook->cmap,&xcol);
		XStoreColor(xhook->display, xhook->cmap2,&xcol);
	}

	/* Work around a nasty DGA bug */
	if (xhook->activecmap)
		XF86DGAInstallColormap(xhook->display,
				       xhook->screen, xhook->cmap);
	else
		XF86DGAInstallColormap(xhook->display,
				       xhook->screen, xhook->cmap2);

	xhook->activecmap = !xhook->activecmap;

	_ggiUnlock(xhook->XLibLock);

	return 0;
}

#endif
