/* $Id: vline.c,v 1.7 1998/09/23 21:36:08 marcus Exp $
***************************************************************************

   Graphics library for GGI. Vertical lines for Xlib.

   Copyright (C) 1998 Marcus Sundberg [marcus@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include <ggi/internal/ggi-dl.h>
#include "Xvisual.h"

int GGI_Xlib_drawvline(ggi_visual *vis,int x,int y,int h)
{
	XDrawLine(XLIB_PRIV(vis)->display, 
			  XLIB_PRIV(vis)->window,
			  XLIB_PRIV(vis)->gc,
			  x, y, x, y+h);
	
	XLIB_DOSYNC(vis);
	return 0;     
}

int GGI_Xlib_putvline(ggi_visual *vis, int x, int y, int h, void *data)
{
	XImage *ximg;
	
	ximg=XCreateImage(XLIB_PRIV(vis)->display, 
					  DefaultVisual(XLIB_PRIV(vis)->display, 0),
					  LIBGGI_PIXFMT(vis)->size, ZPixmap, 0,
					  data, 1, h, 8, 0);
	XPutImage(XLIB_PRIV(vis)->display, 
			  XLIB_PRIV(vis)->window,
			  XLIB_PRIV(vis)->gc,
			  ximg, 0, 0, x, y, 1, h);
	XFree(ximg);

	XLIB_DOSYNC(vis);
	return 0;
}
