/* $Id: visual.c,v 1.12 1998/10/18 15:52:48 becka Exp $
***************************************************************************

   Display-kgi: initialization

   Copyright (C) 1995 Andreas Beck      [andreas@ggi-project.org]
   Copyright (C) 1997 Jason McMullan    [jmcc@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include <unistd.h>
#include <fcntl.h>
#include <sys/mman.h>
#include <signal.h>

#include <kgi/kgi_commands.h>
#include <ggi/internal/ggi-dl.h>

void _ignore_SIGBUS(int unused)
{ 
	signal(SIGBUS,_ignore_SIGBUS);
	sleep(1);	/* Ignore the SIGBUSes */
}

int GGIdlinit(ggi_visual *vis,const char *args,void *argptr)
{
	LIBGGI_FD(vis)=LIBGGI_SELECT_FD(vis)=open(args,O_RDWR);
	if (LIBGGI_FD(vis)<0)
		return GGI_DL_ERROR;

	/* Has mode management */
	vis->opdisplay->getmode=GGIgetmode;
	vis->opdisplay->setmode=GGIsetmode;
	vis->opdisplay->checkmode=GGIcheckmode;
	vis->opdisplay->kgicommand=GGIkgicommand;
	vis->opdisplay->setflags=GGIsetflags;

	/* Has Event management */
	vis->opdisplay->eventpoll=GGIeventpoll;
	vis->opdisplay->eventread=GGIeventread;
	vis->opdisplay->seteventmask=GGIseteventmask;

	vis->opdraw->setorigin=GGIsetorigin;

	/* temporary hack to do away with the SIGBUS ... */
	signal(SIGBUS,_ignore_SIGBUS);

	return GGI_DL_OPDISPLAY|GGI_DL_OPDRAW;
}

int GGIdlcleanup(ggi_visual *vis)
{
	if (LIBGGI_FD(vis) > -1)
		close(LIBGGI_FD(vis));

	return 0;
}
		
#include <ggi/internal/ggidlinit.h>
