/* $Id: events.c,v 1.11 1998/10/26 04:11:07 ajapted Exp $
***************************************************************************

   Display-palemu: events

   Copyright (C) 1998 Andrew Apted    [andrew@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include <string.h>
#include <stdlib.h>

#include <ggi/internal/ggi-dl.h>

#include "palemu.h"


static int handle_special_events(ggi_visual *vis, ggi_event *ev)
{
	/* returns: 1 if swallows event, 0 otherwise */

	if (ev->any.type == evExpose) {

		_ggi_palemu_Transfer(vis, 0, 0, 
				LIBGGI_MODE(vis)->virt.x,
				LIBGGI_MODE(vis)->virt.y);
		return 1;
	}

	if ((ev->any.type == evKeyPress) &&
	    ((ev->key.effect & GII_KM_CTRL) != 0) &&
	    ((ev->key.effect & GII_KM_ALT)  != 0)) {

		/* handle hot-keys here... */
	}

	return 0;
}


/* ---------------------------------------------------------------------- */


#include "../common/evqueue.inc"

ggi_event_mask GGI_palemu_eventpoll(ggi_visual_t vis, ggi_event_mask mask,
			    struct timeval *t)
{
	PalemuHook *ph = PALEMU_PRIV(vis);

	ggi_event_mask evmask;


	DPRINT("display-palemu: eventpoll mask=0x%08x ", mask);

	if (t == NULL) {
		DPRINT("timeout=NULL\n");
	} else {
		DPRINT("timeout=(%d,%d)\n", t->tv_sec, t->tv_usec);
	}


	for (evmask = _ggiEvQueueSeen(vis, mask);
	     evmask == 0;
	     evmask = _ggiEvQueueSeen(vis, mask)) {

		ggi_event ev;

		ggi_event_mask par_mask;

		par_mask = ggiEventPoll(ph->parent, mask | emKeyPress | emExpose, t);

		/* handle event */

		if (par_mask) {
			ggiEventRead(ph->parent, &ev,
				     mask | emKeyPress | emExpose);
			if (!handle_special_events(vis, &ev)) {
				_ggiEvQueueAdd(vis, &ev);
			}
			if (!(par_mask & mask) 
			    && (t->tv_sec < 0
				|| (t->tv_usec <= 0 && t->tv_sec == 0))) {
				/* timeout */
				return 0;
			}
		} else {
			/* timeout */
			return 0;
		}
	}

	return evmask;
}

int GGI_palemu_eventread(ggi_visual_t vis, ggi_event *ev, ggi_event_mask mask)
{
	/* Block if we don't have anything queued... */
	
	GGI_palemu_eventpoll(vis, mask, NULL);

	return _ggiEvQueueRelease(vis, ev, mask);
}
