/* $Id: mode.c,v 1.13 1998/10/18 15:52:57 becka Exp $
***************************************************************************

   Display-sub: mode management

   Copyright (C) 1998 Andreas Beck    [becka@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include <string.h>

#include "SubVisual.h"

int GGI_sub_getapi(ggi_visual *vis, int num, char *apiname, char *arguments)
{
	if(num==0) {
		strcpy(apiname, "display-sub");
		strcpy(arguments, "");
		return 0;
	}

	return -1;
}

int GGI_sub_setmode(ggi_visual *vis,ggi_mode *tm)
{ 
	SubHook *subinfo=LIBGGI_PRIVATE(vis);
	subinfo->position.x=tm->visible.x;
	subinfo->position.y=tm->visible.y;
	subinfo->botright.x=tm->virt.x+tm->visible.x;
	subinfo->botright.y=tm->virt.y+tm->visible.y;

        memcpy(LIBGGI_MODE(vis),tm,sizeof(ggi_mode));
                                                                                                
	return 0;
}

/**********************************/
/* check any mode (text/graphics) */
/**********************************/
int GGI_sub_checkmode(ggi_visual *vis,ggi_mode *tm)
{
	return -1;
}

/************************/
/* get the current mode */
/************************/
int GGI_sub_getmode(ggi_visual *vis,ggi_mode *tm)
{
	return -1;
}

/*************************/
/* set the current flags */
/*************************/
int GGI_sub_setflags(ggi_visual *vis,ggi_flags flags)
{
	SubHook *hook=LIBGGI_PRIVATE(vis);
	if(ggiSetFlags(hook->parent, flags))
		return -1;
	
	LIBGGI_FLAGS(vis)=flags;
	return 0;	
}

int GGI_sub_flush(ggi_visual *vis, int tryflag)
{
	SubHook *hook=LIBGGI_PRIVATE(vis);
	return _ggiInternFlush(hook->parent, tryflag);
}
