/* $Id: events.c,v 1.3 1998/09/20 21:24:41 marcus Exp $
***************************************************************************

   Display-SUID

   Copyright (C) 1998 Andrew Apted    [andrew@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <termios.h>
#include <fcntl.h>

#include <sys/time.h>
#include <sys/types.h>
#include <sys/ioctl.h>

#include <linux/kd.h>
#include <linux/vt.h>

#include "debug.h"
#include <ggi/internal/ggi-dl.h>
#include "../common/evqueue.inc"


int suid_kbd_fd   = -1;
int suid_mouse_fd = -1;

ggi_event_mask GGIeventpoll(ggi_visual_t vis, ggi_event_mask mask,
			    struct timeval *t)
{
	ggi_event_mask evmask;

	int err;
	

	DPRINT("display-fbdev: eventpoll mask=0x%08x ", mask);

	if (t == NULL) {
		DPRINT("timeout=NULL\n");
	} else {
		DPRINT("timeout=(%d,%d)\n", t->tv_sec, t->tv_usec);
	}


	for (evmask = _ggiEvQueueSeen(vis, mask);
	     evmask == 0;
	     evmask = _ggiEvQueueSeen(vis, mask)) {

		fd_set fds;
		int fdmax;

		FD_ZERO(&fds);
		
		FD_SET(suid_kbd_fd, &fds);
		fdmax = suid_kbd_fd;

		if (suid_mouse_fd >= 0) {
			FD_SET(suid_mouse_fd, &fds);
			if (suid_mouse_fd > fdmax) {
				fdmax = suid_mouse_fd;
			}
		}


		/* NB: The following EINTR handling assumes the Linux
		 * behaviour of select(), which modifies the timeout to
		 * indicate the time not slept.
		 */

		err = select(fdmax+1, &fds, NULL, NULL, t);

		if ((err < 0) && (errno == EINTR)) {
			continue;
		
		} else if (err < 0) {
			DPRINT("display-fbdev: select error.\n");
			return 0;

		} if (err == 0) {   /* select timed-out */
			DPRINT("display-fbdev: eventpoll timed out.\n");
			return 0;
		}


		if (FD_ISSET(suid_kbd_fd, &fds)) {
			fbdev_handle_kbd_data(vis);

		} else if ((suid_mouse_fd >= 0) &&
		           FD_ISSET(suid_mouse_fd, &fds)) {
			fbdev_handle_mouse_data(vis);
		}
	}

	return evmask;
}


int GGIeventread(ggi_visual_t vis, ggi_event *ev, ggi_event_mask mask)
{
	/* Block if we don't have anything queued... */
	
	GGIeventpoll(vis, mask, NULL);

	return _ggiEvQueueRelease(vis, ev, mask);
}
