/* $Id: color.c,v 1.10 1998/09/23 21:35:23 marcus Exp $
***************************************************************************

   SVGAlib target: palette driver

   Copyright (C) 1997 Steve Cheng   [steve@ggi-project.org]
   Copyright (C) 1997 Andreas Beck  [becka@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include <ggi/internal/ggi-dl.h>
#include "vgavisual.h"

int GGI_svga_setpalvec(ggi_visual *vis,int start,int len,ggi_color *colormap) {
	int i;

	if (start == GGI_PALETTE_DONTCARE) start = 0;

	if (colormap==NULL || start+len > (1<<GT_DEPTH(LIBGGI_GT(vis))))
		return -1;
                        
	memcpy(vis->palette+start, colormap, len*sizeof(ggi_color)); 

	/* vga_setpalette takes 6-bit r,g,b,
	   so we need to scale ggi_color's 16-bit values. */
	for(i = start; i<start+len; i++) {
		vga_setpalette(i, colormap->r >>10,
				  colormap->g >>10,
				  colormap->b >>10);
		colormap++;
	}
	
	return 0;
}
