/* $Id: visual.c,v 1.21 1998/10/18 15:53:02 becka Exp $
***************************************************************************

   SVGAlib target: initialization

   Copyright (C) 1998 Steve Cheng   [steve@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <signal.h>

#include <ggi/internal/ggi-dl.h>
#include "vgavisual.h"

char *_GGIkeystate;
ggi_visual_t _GGI_ev_vis;

/* SVGAlib's signal handlers */
static int vga_signals[] = {
	SIGHUP, SIGINT, SIGQUIT, SIGILL,
	SIGTRAP, SIGIOT, SIGBUS, SIGFPE,
	SIGSEGV, SIGPIPE, SIGALRM, SIGTERM,
	SIGXCPU, SIGXFSZ, SIGVTALRM,
	SIGPROF, SIGPWR};
static struct sigaction old_signals[sizeof(vga_signals)];



void _GGI_svga_freedbs(ggi_visual *vis) {
	int i;

	for (i=LIBGGI_APPLIST(vis)->num-1; i >= 0; i--) {
		_ggi_db_free(LIBGGI_APPBUFS(vis)[i]);
		_ggi_db_del_buffer(LIBGGI_APPLIST(vis), i);
	}
}


static void _GGIexitfunc(void)
{
	keyboard_close();
	mouse_close();
	vga_setmode(TEXT);
}

static void _GGIchecksvgamodes(ggi_visual *vis)
{
	int modes=0;
	int i;

	SVGA_PRIV(vis)->availmodes =
		_ggi_malloc(vga_lastmodenumber()*sizeof(ggi_modelistmode));

	for (i=1; i <= vga_lastmodenumber(); i++) {
		if (vga_hasmode(i)) {
			vga_modeinfo *modeinfo;
			ggi_modelistmode *sgmode;
			int bpp, size;
			modeinfo = vga_getmodeinfo(i);
			switch(modeinfo->colors) {
			case 2:
				continue; /* 1 bpp doesn't work */
				bpp = size = 1;
				break;
			case 16:
				continue; /* 4 bpp doesn't work */
				bpp = size = 4;
				break;
			case 256:
				bpp = size = 8;
				break;
			case 1<<15:
				bpp = size = 15;
				break;
			case 1<<16:
				bpp = size = 16;
				break;
			case 1<<24:
				bpp = 24;
				if (modeinfo->bytesperpixel==3) {
					size = 24;
				} else {
					size = 32;
				}
				break;
			default:
				continue;
			}
			sgmode = SVGA_PRIV(vis)->availmodes + modes;
			modes++;
			sgmode->x = modeinfo->width;
			sgmode->y = modeinfo->height;
			sgmode->bpp = bpp;
			sgmode->gt = GT_CONSTRUCT(bpp, (bpp <= 8) ?
			      GT_PALETTE : GT_TRUECOLOR, size);
			if ((modeinfo->flags & IS_MODEX))
				sgmode->ismodex = 1;
			else
				sgmode->ismodex = 0;
		}
	}

	if (modes==0) {
		free(SVGA_PRIV(vis)->availmodes);
		SVGA_PRIV(vis)->availmodes=NULL;
	} else {
		SVGA_PRIV(vis)->availmodes =
			_ggi_realloc(SVGA_PRIV(vis)->availmodes,
				     (modes+1)*sizeof(ggi_modelistmode));
		SVGA_PRIV(vis)->availmodes[modes].bpp=0;
	}
}

/* This is exported from svgalib, we use it to check if
   we're called from GGI's svgalib wrapper. */

//extern unsigned char *__svgalib_graph_mem;

int GGIdlinit(ggi_visual *vis,const char *args,void *argptr)
{
	int i;
	
/*	if (__svgalib_graph_mem == (void*) 42) {
		ggiPanic("SVGAlib target called from the SVGAlib wrapper! Terminating.\n");
		}*/
	LIBGGI_PRIVATE(vis)=_ggi_malloc(sizeof(struct svga_priv));

	LIBGGI_GC(vis) = _ggi_malloc(sizeof(ggi_gc));
	
	_GGI_ev_vis = vis;

	/* Save original signal handlers because SVGAlib will set its own */
	for(i = 0; i<sizeof(vga_signals); i++)
		sigaction(vga_signals[i], NULL, old_signals+i);

	if(!_ggiDebugState)
		vga_disabledriverreport();

	vga_safety_fork(_GGIexitfunc);
	if(vga_init()) {
		fprintf(stderr, "display-SVGAlib: vga_init() failed\n");
		return GGI_DL_ERROR;
	}
    
	LIBGGI_FD(vis) = 1;
	LIBGGI_SELECT_FD(vis) = keyboard_init_return_fd();

	_GGIkeystate = keyboard_getstate();
	keyboard_clearstate();
	keyboard_seteventhandler(_GGIkeyboardhandler);

	mouse_init("", vga_getmousetype(), SAMPLE_RATE);
	mouse_seteventhandler((__mouse_handler)_GGImousehandler);
	
	_GGIchecksvgamodes(vis);

	/* Has mode management */
	vis->opdisplay->flush=GGI_svga_flush;
	vis->opdisplay->getmode=GGI_svga_getmode;
	vis->opdisplay->setmode=GGI_svga_setmode;
	vis->opdisplay->getapi=GGI_svga_getapi;
	vis->opdisplay->checkmode=GGI_svga_checkmode;
	vis->opdisplay->setflags=GGI_svga_setflags;

	/* Has Event management */
	vis->opdisplay->eventpoll=GGI_svga_eventpoll;
	vis->opdisplay->eventread=GGI_svga_eventread;
	vis->opdisplay->seteventmask=GGIseteventmask;

	return GGI_DL_OPDISPLAY;
}

int GGIdlcleanup(ggi_visual *vis)
{
	int i;

	_GGIexitfunc();

	_GGI_svga_freedbs(vis);

	/* Get rid of SVGAlib's signal handlers */
	for(i = 0; i<sizeof(vga_signals); i++)
		sigaction(vga_signals[i], old_signals+i, NULL);

#ifndef ALWAYS_SEGFAULT_ON_EXIT
	if(!_ggiDebugState)
		signal(SIGSEGV,_exit);
#endif

	fflush(stderr);
	fflush(stdout);

	if (SVGA_PRIV(vis)->availmodes != NULL)
		free(SVGA_PRIV(vis)->availmodes);
	if (LIBGGI_PRIVATE(vis) != NULL)
		free(LIBGGI_PRIVATE(vis)); 

	if(vis->palette)
		free(vis->palette);
	free(LIBGGI_GC(vis));

	return 0;
}

#include <ggi/internal/ggidlinit.h>
