/* $Id: copybox.c,v 1.8 1998/09/25 21:33:14 becka Exp $
***************************************************************************

   SVGAlib target vgagl helper: copybox.

   Copyright (C) 1998 Marcus Sundberg   [marcus@ggi-project.org]
   Copyright (C) 1997 Jason McMullan    [jmcc@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include <string.h>

#include <ggi/internal/ggi-dl.h>

int GGI_vgagl_copybox(ggi_visual *vis,int x,int y,int w,int h,int nx,int ny)
{
	int line;

	/* Clipping */
	if (nx< (LIBGGI_GC(vis)->cliptl.x)) {
		int diff=(LIBGGI_GC(vis)->cliptl.x)-nx;
		nx+=diff;
		x +=diff;
		w -=diff;
	}
	if (nx+w>=(LIBGGI_GC(vis)->clipbr.x)) {
		w=(LIBGGI_GC(vis)->clipbr.x)-nx;
	}
	if (ny< (LIBGGI_GC(vis)->cliptl.y)) {
		int diff=(LIBGGI_GC(vis)->cliptl.y)-ny;
		ny+=diff;
		y +=diff;
		h -=diff;
	}
	if (ny+h>(LIBGGI_GC(vis)->clipbr.y)) {
		h=(LIBGGI_GC(vis)->clipbr.y)-ny;
	}

	/* If nothing to copy or the source leaves the virtual screen, bail out. */
	if (w<=0||h<=0||x<0||y<0||x+w>LIBGGI_VIRTX(vis)||y+h>LIBGGI_VIRTY(vis))
		return 0;
	
	if (ny < y) {
		obox=(uint8 *)(LIBGGI_CURREAD(vis))+y*LIBGGI_FB_R_STRIDE(vis)+x;
		nbox=(uint8 *)(LIBGGI_CURWRITE(vis))+ny*LIBGGI_FB_W_STRIDE(vis)+nx;
		for (line=0; line<h; line++,obox+=LIBGGI_FB_R_STRIDE(vis),
			     nbox+=LIBGGI_FB_W_STRIDE(vis))
			memmove(nbox,obox,w);
	} else {
		obox=(uint8 *)(LIBGGI_CURREAD(vis))+(y+h-1)*LIBGGI_FB_R_STRIDE(vis)+x;
		nbox=(uint8 *)(LIBGGI_CURWRITE(vis))+(ny+h-1)*LIBGGI_FB_W_STRIDE(vis)+nx;
		for (line=0;line<h; line++,obox-=LIBGGI_FB_R_STRIDE(vis),
			     nbox-=LIBGGI_FB_W_STRIDE(vis))
			memmove(nbox,obox,w);
	}
	return 0;
}
