/* 
   Graphics library for GGI. CRT specifics

   Copyright (C) 1998 Marcus Sundberg - marcus@ggi-project.org
   Copyright (C) 1998 Steve Cheng <steve@ggi-project.org>
   Copyright (C) 1997 Jason McMullan - jmcc@ggi-project.org

   If you do any modifications, I would like you to send diffs to me
   to allow for collecting a more and more complete set of drivers and
   to improve existing ones.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <stdio.h>
#include <stdlib.h>

#include <ggi/internal/ggi-dl.h>
#include "misc_int.h"
#include "vgavisual.h"
#include "svgamisc.h"

int GGIwaitraypos(ggi_visual *vis,sint32 *x,sint32 *y)
{
	if (*y == GGI_RP_SYNC && *x == GGI_RP_DONTCARE) {
		vga_waitretrace();
		return 0;
	}
	*x = GGI_RP_DONTCARE;
	*y = GGI_RP_SYNC;

	return 1;
}

#if defined(__linux__) && defined (WANT_DANGEROUS_SPLITLINE)
#include <asm/io.h>
int GGIsetsplitline(ggi_visual *vis,int y)
{
#define CRT_LINECOMPARE      0x18
#define CR07_LINECOMPARE_B8  0x10
#define CR09_LINECOMPARE_B9  0x40
#define outbCRT(val,reg) outw(((val) << 8) | (reg), CRTI)
	register uint8 foo;
	unsigned short CRTI,CRTD;

	if (y<0 || y>LIBGGI_MODE(vis)->visible.y) return -1;
	if (LIBGGI_MODE(vis)->visible.y<0x100) y <<= 1;

	CRTI=SVGAMISC_PRIV(vis)->CRTI;
	CRTD=SVGAMISC_PRIV(vis)->CRTD;

	outbCRT(y & 0xFF, CRT_LINECOMPARE);

	outb(0x07, CRTI);

	foo = (y & 0x0100)
		? inb(CRTD) | CR07_LINECOMPARE_B8
		: inb(CRTD) & ~CR07_LINECOMPARE_B8;
	outbCRT(foo, 0x07);

	outb(0x09, CRTI);
	foo = (y & 0x0200)
		? inb(CRTD) | CR09_LINECOMPARE_B9
		: inb(CRTD) & ~CR09_LINECOMPARE_B9;
	outbCRT(foo, 0x09);
	
	return 0;
}
#endif

