/* $Id: test2.c,v 1.8 1998/10/29 21:37:02 becka Exp $
***************************************************************************

   Test extension test2.c

   Copyright (C) 1997 Uwe Maurer - uwe_maurer@t-online.de
   Copyright (C) 1998 Andreas Beck - becka@ggi-project.org
  
   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
 
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
 
   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include <stdio.h>
#include <string.h>

#include <ggi/internal/internal.h>

#include "test1.h"
#include "test2.h"

/*
 * The API of Extension #2 looks a bit like this :
 * It happens to need Extension #1 internally.
 */

/* Extension ID. Defaulting to -1 should make segfault on abuse more likely ... */
ggi_extid ggiTest2ID=-1;

static int changed(ggi_visual_t vis,int whatchanged)
{
	printf("load extension 2 - vis: %p %i\n",
		vis,whatchanged);
	return GGI_DL_EXTENSION;
}

int ggiTest2Init(void)
{
	ggiTest1Init();	/* Make sure #1 is there - we need it */

	ggiTest2ID=ggiExtensionRegister("Ext2",123,changed);
	printf("Initialized Test2 extension. ID: %i\n",ggiTest2ID);

	return ggiTest2ID >= 0 ? 0 : -1;
}

int ggiTest2Exit(void)
{
	int rc;
	rc=ggiExtensionUnregister(ggiTest2ID);
	printf("DeInitailized Test2 extension. rc=%i\n", rc);

	if (rc>=0) ggiTest1Exit();	/* Release #1. */

	return rc;
}

int ggiTest2Attach(ggi_visual_t vis)
{
	int rc;
	rc=ggiExtensionAttach(vis,ggiTest2ID);
	printf("Attached Test2 extension to %p. rc=%i\n", vis, rc);

	if (rc==0) {	/* We are actually creating the primary instance. */
		ggiTest1Attach(vis);
		strcpy(LIBGGI_EXT(vis,ggiTest2ID),"Test 2 private Data !");
	}

	return rc;
}

int ggiTest2Detach(ggi_visual_t vis)
{
	int rc;
	rc=ggiExtensionDetach(vis,ggiTest2ID);
	printf("Detached Test2 extension from %p. rc=%i\n", vis, rc);
	if (rc==0) ggiTest1Detach(vis);

	return rc;
}

void ggiTest2PrintLocaldata(ggi_visual_t vis)
{
	ggiTest1PrintLocaldata(vis);
	printf("%s\n",(char *)LIBGGI_EXT(vis,ggiTest2ID));
}

void ggiTest2SetLocaldata  (ggi_visual_t vis,char *content)
{
	strcpy(LIBGGI_EXT(vis,ggiTest2ID),content);
}

