/* $Id: debug.h,v 1.4 1998/10/24 04:03:54 marcus Exp $
***************************************************************************

   LibGGI debugging macros

   Copyright (C) 1998	Marcus Sundberg		[marcus@ggi-project.org]
  
   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
 
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
 
   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#ifndef _GGI_INTERNAL_DEBUG_H
#define _GGI_INTERNAL_DEBUG_H

#include <stdio.h>
#include <stdarg.h>
#include <ggi/types.h>
#include <ggi/gg.h>

extern uint32 _ggiDebugState;
extern int _ggiDebugSync;

/* Debugging types
 * bit 0 is reserved! */

#define GGIDEBUG_CORE		(1<<1)	/*   2 */
#define GGIDEBUG_MODE		(1<<2)	/*   4 */
#define GGIDEBUG_COLOR		(1<<3)	/*   8 */
#define GGIDEBUG_DRAW		(1<<4)	/*  16 */
#define GGIDEBUG_MISC		(1<<5)	/*  32 */
#define GGIDEBUG_LIBS		(1<<6)	/*  64 */
#define GGIDEBUG_EVENTS		(1<<7)	/* 128 */

#define GGIDEBUG_ALL	0xffffffff

#ifndef __GNUC__
#define DPRINT_MODE	DPRINT
#define DPRINT_COLOR	DPRINT
#define DPRINT_DRAW	DPRINT

#else /* !__GNUC__ */

#ifdef DEBUG
#define DPRINT_MODE(form,args...)   if (_ggiDebugState & GGIDEBUG_MODE) { ggDPrintf(_ggiDebugSync,__FILE__,__LINE__,form, ##args); }
#define DPRINT_COLOR(form,args...)  if (_ggiDebugState & GGIDEBUG_COLOR) { ggDPrintf(_ggiDebugSync,__FILE__,__LINE__,form, ##args); }
#define DPRINT_DRAW(form,args...)   if (_ggiDebugState & GGIDEBUG_DRAW) { ggDPrintf(_ggiDebugSync,__FILE__,__LINE__,form, ##args); }
#else /* DEBUG */
#define DPRINT(form,args...)		do { } while (0)
#define DPRINT_MODE(form,args...)	do { } while (0)
#define DPRINT_COLOR(form,args...)	do { } while (0)
#define DPRINT_DRAW(form,args...)	do { } while (0)
#endif /* DEBUG */
#endif /* !__GNUC__ */

#ifdef DEBUG
#define LIBGGI_ASSERT(x,str) \
{ if (!(x)) { \
	fprintf(stderr,"LIBGGI:%s:%d: INTERNAL ERROR: %s\n",__FILE__,__LINE__,str); \
	exit(1); \
} }
#define LIBGGI_APPASSERT(x,str) \
{ if (!(x)) { \
	fprintf(stderr,"LIBGGI:%s:%d: APPLICATION ERROR: %s\n",__FILE__,__LINE__,str); \
	exit(1); \
} }
#else 
#define LIBGGI_ASSERT(x,str)	do { } while (0)
#define LIBGGI_APPASSERT(x,str)	do { } while (0)
#endif /* DEBUG */

#endif /* _GGI_INTERNAL_DEBUG_H */
