/****************************************************************************
**  Copyright (C) 1997 Uwe Maurer - uwe_maurer@t-online.de
**  Copyright (C) 1998 Andreas Beck - becka@ggi-project.org
**  Copyright (C) 1998 Jon Taylor - taylorj@ggi-project.org
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
***************************************************************************** 
*/

#include <stdio.h>

//#include <ggi/internal/internal3d.h>
#include <ggi/ggi3d.h>

int main()
{
	ggi_visual_t vis;
	int temp;

	if (ggiInit() != 0) 
	{
		fprintf(stderr, "Unable to initialize LibGGI, exiting\n");
		exit(1);
	}
	if (ggi3DInit() != 0) 
	{
		fprintf(stderr, "Unable to initialize LibGGI3D, exiting\n");
		exit(1);
	}
	if ((vis=ggiOpen(NULL)) == NULL) 
	{
		fprintf(stderr, "Unable to open default visual, exiting\n");
		exit(1);
	}
	printf("A\n");

	ggiSetGraphMode(vis, 640, 480, GGI_AUTO, GGI_AUTO, GGI_AUTO);
	
	ggi3DOpen(vis);
	
	ggi3DDrawTriangle(vis, 1, 1, 1, 1, 1, 1, 1, 1, 1);

	ggi3DClose(vis);

	ggiClose(vis);

	temp=ggi3DExit();printf("ggi3DExit : %i\n", temp);
	temp=ggiExit();  printf("ggiExit  : %i\n", temp);
	
	return 0;
}
